/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.file;

import com.google.common.collect.Maps;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.file.AtlantisConfig;
import de.waterdu.atlantis.file.AtlantisConfigFinder;
import de.waterdu.atlantis.playerdata.PlayerData;
import de.waterdu.atlantis.trident.Trident;
import de.waterdu.atlantis.ui.api.Decorations;
import de.waterdu.atlantis.ui.api.Page;
import de.waterdu.atlantis.ui.internal.FontUtils;
import de.waterdu.atlantis.util.config.Leaderboard;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class AtlantisData {
    private static final AtomicBoolean REGISTERED = new AtomicBoolean(false);
    private static final Map<Class<? extends Page>, Decorations> MAPPED_DECORATIONS = Maps.newHashMap();

    private AtlantisData() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static void register() {
        if (!REGISTERED.get()) {
            AtlantisConfigFinder.init(false);
            Atlantis.CONFIG.enqueue(() -> {
                long delay;
                Settings settings = Settings.getSettings();
                int threads = settings.getThreads();
                if (threads <= 0) {
                    threads = Trident.countAquaMods() * 2 + 4;
                    AtlantisLogger.infoForced("Automatically creating " + threads + " threads", new Object[0]);
                } else {
                    AtlantisLogger.infoForced("Creating " + threads + " threads", new Object[0]);
                }
                Atlantis.THREAD_POOL.setSize(threads);
                if (settings.isUseAsyncAutosaver()) {
                    delay = settings.getAsyncSaveDelaySeconds();
                    Atlantis.THREAD_POOL.scheduleAtFixedRate(AtlantisConfig::asyncSave, delay, delay, TimeUnit.SECONDS);
                }
                if (settings.getLeaderboardRecalculateGapSeconds() > 0L) {
                    delay = settings.getLeaderboardRecalculateGapSeconds();
                    boolean multithreaded = settings.isLeaderboardMultithreadedRecalculate();
                    Atlantis.THREAD_POOL.scheduleAtFixedRate(() -> Leaderboard.recalculateAll(multithreaded), delay, delay, TimeUnit.SECONDS);
                }
                AtlantisData.mapDecorations();
            });
            try {
                FontUtils.init();
            }
            catch (Exception e) {
                AtlantisLogger.error("Failed to init FontHelper!", new Object[0]);
                e.printStackTrace();
            }
            REGISTERED.set(true);
        }
    }

    public static void mapDecorations() {
        for (Decorations def : Atlantis.CONFIG.getAll(Decorations.class)) {
            if (def.getClassDef() == null) continue;
            MAPPED_DECORATIONS.put(def.getClassDef(), def);
        }
    }

    public static Decorations getDecorations(Page page) {
        return MAPPED_DECORATIONS.get(page.getClass());
    }

    public static Decorations getDecorations(Class<? extends Page> page) {
        return MAPPED_DECORATIONS.get(page);
    }

    public static CompletableFuture<PlayerData> getPlayer(PlayerReference player) {
        return player.entity().map(AtlantisData::getPlayer).orElse(AtlantisData.getPlayer(player.uuid()));
    }

    public static CompletableFuture<PlayerData> getPlayer(PlayerEntity player) {
        return AtlantisData.getPlayer(player.func_110124_au()).whenComplete((p, err) -> p.setNameAndUpdate(player.func_200200_C_().getString()));
    }

    public static CompletableFuture<PlayerData> getPlayer(UUID uuid) {
        return Atlantis.CONFIG.getForOrPut(PlayerData.class, uuid, () -> new PlayerData(uuid));
    }

    public static CompletableFuture<PlayerData> getPlayer(String name) {
        return Atlantis.CONFIG.getFor(PlayerData.class, name);
    }

    public static ItemStack getSkull(UUID uuid) {
        PlayerData pd = AtlantisData.getPlayer(uuid).getNow(null);
        return pd == null ? new ItemStack((IItemProvider)Items.field_196184_dx) : pd.getSkullItemStack();
    }
}

