/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.file;

import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.file.AtlantisConfig;
import de.waterdu.atlantis.file.Config;
import de.waterdu.atlantis.file.DataType;
import de.waterdu.atlantis.file.datatypes.Configuration;
import de.waterdu.atlantis.file.datatypes.Data;
import de.waterdu.atlantis.file.datatypes.PlayerData;
import de.waterdu.atlantis.playerdata.UUIDNameCache;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import de.waterdu.atlantis.util.text.Text;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;

public class AtlantisConfigProxy {
    private static final Map<String, Impl> IMPLEMENTATIONS = Maps.newConcurrentMap();

    private AtlantisConfigProxy() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static Impl of(String modID) {
        return IMPLEMENTATIONS.computeIfAbsent(modID, x$0 -> new Impl((String)x$0));
    }

    public static class Impl {
        private final AtlantisConfig internal;
        private final Map<Class<?>, String> canonicalNameCache = Maps.newConcurrentMap();

        private Impl(String modID) {
            this.internal = AtlantisConfig.getInstance(modID);
        }

        private String getCanonicalName(Class<?> clazz) {
            return this.canonicalNameCache.computeIfAbsent(clazz, Class::getCanonicalName);
        }

        public <T extends Configuration> Config<T> getConfig(Class<T> clazz) {
            return this.internal.getConfig(this.getCanonicalName(clazz));
        }

        public void registerTypeAdapters(Consumer<GsonBuilder> consumer) {
            this.internal.registerTypeAdapters(consumer);
        }

        public <T extends Configuration> void addPutListener(Class<? extends T> clazz, Function<T, Boolean> listener) {
            Config<T> config = this.getConfig(clazz);
            config.addPutListener(listener);
        }

        public <T extends Configuration> T get(Class<? extends T> clazz) {
            if (!this.internal.ready) {
                return this.getDuringRegistration(clazz);
            }
            return this.getConfig(clazz).get();
        }

        public <T extends Configuration> T getDuringRegistration(Class<? extends T> clazz) {
            Config<T> config = this.getConfig(clazz);
            try {
                boolean result = config.read(true).get();
                if (!result) {
                    config.write();
                }
                config.remapLang();
                return config.get();
            }
            catch (InterruptedException | ExecutionException e) {
                AtlantisLogger.error("Failed immediate read of {}!", config.getName());
                return null;
            }
        }

        public <T extends Configuration> T getOrElse(Class<? extends T> clazz, T orElse) {
            if (this.internal == null || !this.internal.ready) {
                return orElse;
            }
            T result = this.getConfig(clazz).get();
            return result == null ? orElse : result;
        }

        public <T extends Configuration> T getOrElse(T orElse) {
            return (T)this.getOrElse(orElse.getClass(), orElse);
        }

        public <T extends Configuration> Collection<T> getAll(Class<? extends T> clazz) {
            String className = this.getCanonicalName(clazz);
            Config config = this.internal.getConfig(className);
            boolean first = true;
            int count = 2000;
            while (true) {
                if (count >= 2000) {
                    if (!config.isBusy()) break;
                    if (first) {
                        AtlantisLogger.info(config.getName() + " is busy, waiting.", new Object[0]);
                        first = false;
                    }
                    count = 0;
                }
                ++count;
            }
            return config.getAll();
        }

        public boolean isBusy() {
            if (!this.internal.ready) {
                return true;
            }
            for (Config<? extends Configuration> config : this.internal.configs.values()) {
                if (!config.isBusy()) continue;
                return true;
            }
            return false;
        }

        public void enqueue(Runnable task) {
            if (this.isBusy()) {
                if (this.internal.scheduledTasks.isEmpty()) {
                    this.internal.scheduledTasks.add(task);
                    Atlantis.THREAD_POOL.repeatUntilComplete(() -> {
                        if (this.isBusy()) {
                            return false;
                        }
                        for (Runnable scheduledTask : this.internal.scheduledTasks) {
                            scheduledTask.run();
                        }
                        this.internal.scheduledTasks.clear();
                        return true;
                    }, Settings.getSettings().getScheduledTaskDelay());
                } else {
                    this.internal.scheduledTasks.add(task);
                }
            } else {
                task.run();
            }
        }

        public <T extends Configuration> boolean isBusy(Class<T> clazz) {
            return !this.internal.ready || this.internal.getConfig(this.getCanonicalName(clazz)).isBusy();
        }

        public <T extends Configuration> void enqueue(Class<T> clazz, Consumer<Collection<T>> task) {
            this.getConfig(clazz).runTask(task);
        }

        public <T extends Configuration> void put(Class<? extends T> clazz, T instance) {
            this.internal.getConfig(this.getCanonicalName(clazz)).put(instance);
        }

        public <T extends Configuration> void put(T instance) {
            this.put(instance.getClass(), instance);
        }

        public <T extends Configuration> Text format(Class<T> clazz, String key, Object ... args) {
            Config<T> config = this.getConfig(clazz);
            if (config.isLang()) {
                return config.format(key, args);
            }
            return Text.empty();
        }

        public <T extends Configuration> Text formatPositive(Class<T> clazz, String key, Object ... args) {
            Config<T> config = this.getConfig(clazz);
            if (config.isLang()) {
                return config.format("prefixPositive", new Object[0]).append(config.format(key, args));
            }
            return Text.empty();
        }

        public <T extends Configuration> Text formatNeutral(Class<T> clazz, String key, Object ... args) {
            Config<T> config = this.getConfig(clazz);
            if (config.isLang()) {
                return config.format("prefixNeutral", new Object[0]).append(config.format(key, args));
            }
            return Text.empty();
        }

        public <T extends Configuration> Text formatNegative(Class<T> clazz, String key, Object ... args) {
            Config<T> config = this.getConfig(clazz);
            if (config.isLang()) {
                return config.format("prefixNegative", new Object[0]).append(config.format(key, args));
            }
            return Text.empty();
        }

        public <T extends Configuration> CompletableFuture<T> getFor(Class<T> clazz, UUID uuid) {
            return this.getConfig(clazz).get(uuid);
        }

        public <T extends Configuration> T getNow(Class<T> clazz, UUID uuid) {
            return this.getConfig(clazz).getNow(uuid);
        }

        public <T extends Configuration> CompletableFuture<T> getForOrPut(Class<T> clazz, UUID uuid, Supplier<T> orElse) {
            Config config = this.getConfig(clazz);
            return this.getConfig(clazz).get(AtlantisConfig.copyUUID(uuid)).thenApply(instance -> {
                if (instance == null) {
                    instance = (Configuration)orElse.get();
                    config.put(instance);
                    instance.save();
                }
                return instance;
            });
        }

        public <T extends Configuration> CompletableFuture<T> remove(Class<T> clazz, PlayerReference player) {
            return this.remove(clazz, player.uuid());
        }

        public <T extends Configuration> CompletableFuture<T> remove(Class<T> clazz, ServerPlayerEntity player) {
            return this.remove(clazz, player.func_110124_au());
        }

        public <T extends Configuration> CompletableFuture<T> remove(Class<T> clazz, UUID uuid) {
            return this.getConfig(clazz).remove(AtlantisConfig.copyUUID(uuid));
        }

        public <T extends Configuration> CompletableFuture<T> remove(Class<T> clazz, String name) {
            return this.getConfig(clazz).remove(name);
        }

        public <T extends Configuration> CompletableFuture<T> getFor(Class<T> clazz, String name) {
            Config<T> config = this.getConfig(clazz);
            if (config.isPlayerData()) {
                return config.get(UUIDNameCache.get(name));
            }
            return CompletableFuture.completedFuture(config.getNameDataMap().get(name));
        }

        public <T extends Configuration> T getNow(Class<T> clazz, String name) {
            Config<T> config = this.getConfig(clazz);
            if (config.isPlayerData()) {
                return config.getNow(UUIDNameCache.get(name));
            }
            return (T)((Configuration)config.getNameDataMap().get(name));
        }

        public <T extends Configuration> CompletableFuture<T> getFor(Class<T> clazz, PlayerReference player) {
            return this.getConfig(clazz).get(player.uuid());
        }

        public <T extends Configuration> T getNow(Class<T> clazz, PlayerReference player) {
            return this.getNow(clazz, player.uuid());
        }

        public <T extends Configuration> CompletableFuture<T> getFor(Class<T> clazz, ServerPlayerEntity player) {
            return this.getConfig(clazz).get(player.func_110124_au());
        }

        public <T extends Configuration> T getNow(Class<T> clazz, ServerPlayerEntity player) {
            return this.getNow(clazz, player.func_110124_au());
        }

        public <T extends Configuration> void load(Class<T> clazz) {
            this.internal.getConfig(this.getCanonicalName(clazz)).read();
        }

        public <T extends Configuration> void save(Class<T> clazz) {
            Atlantis.THREAD_POOL.submit(() -> this.internal.getConfig(this.getCanonicalName(clazz)).write());
        }

        public <T extends Configuration> void save(T data) {
            this.save(data, false);
        }

        public <T extends Configuration> void save(T data, boolean immediate) {
            Runnable writeTask = () -> this.internal.getConfig(this.getCanonicalName(data.getClass())).write(data, immediate);
            if (data instanceof PlayerData) {
                writeTask.run();
            } else {
                Atlantis.THREAD_POOL.submit(writeTask);
            }
        }

        public void loadAll(DataType type) {
            boolean configuration = type == DataType.ALL || type == DataType.CONFIGURATION;
            boolean data = type == DataType.ALL || type == DataType.ALL_DATA || type == DataType.DATA;
            boolean playerData = type == DataType.ALL || type == DataType.ALL_DATA || type == DataType.PLAYER_DATA;
            for (Config<? extends Configuration> config : this.internal.configs.values()) {
                if (!(!(config.get() instanceof Data) && configuration || !(config.get() instanceof PlayerData) && config.get() instanceof Data && data) && (!(config.get() instanceof PlayerData) || !playerData)) continue;
                config.read();
            }
        }

        public void saveAll(DataType type) {
            Atlantis.THREAD_POOL.submit(() -> {
                boolean configuration = type == DataType.ALL || type == DataType.CONFIGURATION;
                boolean data = type == DataType.ALL || type == DataType.ALL_DATA || type == DataType.DATA;
                boolean playerData = type == DataType.ALL || type == DataType.ALL_DATA || type == DataType.PLAYER_DATA;
                for (Config<? extends Configuration> config : this.internal.configs.values()) {
                    if (!(!(config.get() instanceof Data) && configuration || !(config.get() instanceof PlayerData) && config.get() instanceof Data && data) && (!(config.get() instanceof PlayerData) || !playerData)) continue;
                    config.write();
                }
            });
        }
    }
}

