/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.file;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.file.AtlantisConfig;
import de.waterdu.atlantis.file.auto.LoadOrder;
import de.waterdu.atlantis.file.auto.NoConfiguration;
import de.waterdu.atlantis.file.datatypes.Configuration;
import de.waterdu.atlantis.file.storage.Flatfile;
import de.waterdu.atlantis.file.storage.Storage;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class AtlantisConfigFinder {
    private static final Type ANNOTATION_TYPE = Type.getType(de.waterdu.atlantis.file.auto.AtlantisConfig.class);
    private static final Supplier<Storage> DEFAULT_STORAGE = Flatfile::new;
    private static final Map<String, List<AquaConfigInstance<? extends Configuration>>> INSTANCES = Maps.newHashMap();
    private static final AtomicBoolean FOUND = new AtomicBoolean(false);

    private AtlantisConfigFinder() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static void find() {
        if (!FOUND.getAndSet(true)) {
            List annotations = ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> ANNOTATION_TYPE.equals((Object)a.getAnnotationType())).collect(Collectors.toList());
            HashMap classCache = Maps.newHashMap();
            annotations.stream().filter(a -> ANNOTATION_TYPE.equals((Object)a.getAnnotationType())).forEach(data -> AtlantisConfigFinder.scan(classCache, data.getClassType(), data.getAnnotationData()));
        }
    }

    private static void scan(Map<Type, Class<? extends Configuration>> classCache, Type type, Map<String, Object> data) {
        Class<Configuration> clazz;
        if (classCache.containsKey(type)) {
            clazz = classCache.get(type);
        } else {
            try {
                clazz = Class.forName(type.getClassName(), false, AtlantisConfigFinder.class.getClassLoader());
                classCache.put(type, clazz);
            }
            catch (ClassCastException | ClassNotFoundException ignored) {
                return;
            }
        }
        AtlantisConfigFinder.register(clazz.getAnnotation(de.waterdu.atlantis.file.auto.AtlantisConfig.class), clazz);
    }

    private static void register(de.waterdu.atlantis.file.auto.AtlantisConfig data, Class<? extends Configuration> clazz) {
        String modID = data.modID();
        String path = data.path();
        LoadOrder loadOrder = data.loadOrder();
        boolean forceLoad = data.forceLoad();
        boolean lang = data.lang();
        boolean aon = data.aon() || path.endsWith(".aon");
        Class<? extends Configuration> storageProviderClass = data.storageProviderClass();
        String storageProviderMethod = data.storageProviderMethod();
        Supplier<Storage> storageSupplier = !storageProviderClass.equals(NoConfiguration.class) && !storageProviderMethod.isEmpty() ? () -> {
            try {
                Object storageProvider = AtlantisConfig.get(modID, storageProviderClass);
                try {
                    Method method = storageProvider.getClass().getDeclaredMethod(storageProviderMethod, new Class[0]);
                    return (Storage)method.invoke(storageProvider, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    Method method = storageProvider.getClass().getDeclaredMethod(storageProviderMethod, String.class);
                    return (Storage)method.invoke(storageProvider, modID);
                }
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                AtlantisLogger.error("Failed to supply storage from {}#{}, using default.", storageProviderClass.getSimpleName(), storageProviderMethod);
                return DEFAULT_STORAGE.get();
            }
        } : () -> {
            Class<? extends Storage> storageClass = data.storage();
            try {
                return storageClass.newInstance();
            }
            catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException e) {
                AtlantisLogger.error("Failed to instantiate new storage " + storageClass.getSimpleName() + ", using default.", new Object[0]);
                return DEFAULT_STORAGE.get();
            }
        };
        try {
            INSTANCES.computeIfAbsent(modID, ___ -> Lists.newArrayList()).add(new AquaConfigInstance<Configuration>(loadOrder, path, clazz, storageSupplier, forceLoad, lang, aon));
        }
        catch (IllegalAccessException | InstantiationException e) {
            AtlantisLogger.error("Failed to instantiate new " + modID + ":" + path + " with zero-args constructor.", new Object[0]);
        }
    }

    @Deprecated
    public static void init(boolean all) {
        List<AquaConfigInstance<? extends Configuration>> atlantis = INSTANCES.remove("atlantis");
        if (atlantis != null) {
            AtlantisConfigFinder.init0("atlantis", atlantis);
        }
        if (all) {
            for (Map.Entry<String, List<AquaConfigInstance<? extends Configuration>>> entry : INSTANCES.entrySet()) {
                AtlantisConfigFinder.init0(entry.getKey(), entry.getValue());
            }
            AtlantisConfigFinder.gc();
        }
    }

    private static void init0(String modID, List<AquaConfigInstance<? extends Configuration>> instances) {
        instances.sort(Comparator.comparingInt(instance -> ((AquaConfigInstance)instance).order.ordinal()));
        for (AquaConfigInstance<? extends Configuration> instance2 : instances) {
            AtlantisConfig.register(modID, ((AquaConfigInstance)instance2).path, ((AquaConfigInstance)instance2).clazz, ((AquaConfigInstance)instance2).instance, (Storage)((AquaConfigInstance)instance2).storage.get(), ((AquaConfigInstance)instance2).forceLoad, ((AquaConfigInstance)instance2).lang, ((AquaConfigInstance)instance2).aon, ((AquaConfigInstance)instance2).order);
        }
        AtlantisConfig.postRegistration(modID);
    }

    private static void gc() {
        INSTANCES.clear();
    }

    private static class AquaConfigInstance<T extends Configuration> {
        private final LoadOrder order;
        private final String path;
        private final Class<T> clazz;
        private final T instance;
        private final Supplier<Storage> storage;
        private final boolean forceLoad;
        private final boolean lang;
        private final boolean aon;

        public AquaConfigInstance(LoadOrder order, String path, Class<T> clazz, Supplier<Storage> storage, boolean forceLoad, boolean lang, boolean aon) throws InstantiationException, IllegalAccessException {
            this.order = order;
            this.path = path;
            this.clazz = clazz;
            this.instance = (Configuration)clazz.newInstance();
            this.storage = storage;
            this.forceLoad = forceLoad;
            this.lang = lang;
            this.aon = aon;
        }
    }
}

