/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.file;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.file.Config;
import de.waterdu.atlantis.file.DataType;
import de.waterdu.atlantis.file.auto.LoadOrder;
import de.waterdu.atlantis.file.datatypes.Configuration;
import de.waterdu.atlantis.file.datatypes.Data;
import de.waterdu.atlantis.file.datatypes.NamedData;
import de.waterdu.atlantis.file.datatypes.PlayerData;
import de.waterdu.atlantis.file.storage.Storage;
import de.waterdu.atlantis.file.typeadapters.InterfaceTypeAdapter;
import de.waterdu.atlantis.file.typeadapters.NumberListTypeAdapter;
import de.waterdu.atlantis.file.typeadapters.ResourceLocationTypeAdapter;
import de.waterdu.atlantis.meta.ConfigEvent;
import de.waterdu.atlantis.pixelmon.AtlantisPixelmon;
import de.waterdu.atlantis.ui.api.UIDef;
import de.waterdu.atlantis.util.config.DatabaseSettings;
import de.waterdu.atlantis.util.config.Leaderboard;
import de.waterdu.atlantis.util.config.RedisSettings;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.item.ParsedItemStack;
import de.waterdu.atlantis.util.java.math.Formula;
import de.waterdu.atlantis.util.level.LazyLevel;
import de.waterdu.atlantis.util.level.LevelPosition;
import de.waterdu.atlantis.util.level.Position;
import de.waterdu.atlantis.util.text.Text;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;

public class AtlantisConfig {
    private static final AtomicBoolean INIT = new AtomicBoolean(false);
    private static final Map<String, AtlantisConfig> INSTANCES = new ConcurrentHashMap<String, AtlantisConfig>();
    private static final Map<Class<?>, String> CLASS_TO_MOD = new ConcurrentHashMap();
    private static final List<Config<? extends PlayerData>> PLAYER_CONFIGS = new ArrayList<Config<? extends PlayerData>>();
    protected final List<Runnable> scheduledTasks = new ArrayList<Runnable>();
    private boolean gsonBuilt = false;
    private final GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().serializeNulls().setLenient().registerTypeAdapter(Configuration.class, new InterfaceTypeAdapter()).registerTypeAdapter(Data.class, new InterfaceTypeAdapter()).registerTypeAdapter(NamedData.class, new InterfaceTypeAdapter()).registerTypeAdapter(PlayerData.class, new InterfaceTypeAdapter()).registerTypeAdapter(UIDef.Data.class, (Object)new UIDef.Data.TypeAdapter()).registerTypeAdapter(UIDef.class, (Object)new UIDef.TypeAdapter()).registerTypeAdapter(Text.class, (Object)new Text.TypeAdapter()).registerTypeAdapter(Text.Immutable.class, (Object)new Text.Immutable.TypeAdapter()).registerTypeAdapter(ParsedItemStack.class, (Object)new ParsedItemStack.TypeAdapter()).registerTypeAdapter(LazyLevel.class, (Object)new LazyLevel.TypeAdapter()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocationTypeAdapter()).registerTypeAdapter(Position.class, (Object)new Position.TypeAdapter()).registerTypeAdapter(LevelPosition.class, (Object)new LevelPosition.TypeAdapter()).registerTypeAdapter(Leaderboard.class, (Object)new Leaderboard.LeaderboardTypeAdapter()).registerTypeAdapter(DatabaseSettings.class, (Object)new DatabaseSettings.TypeAdapter()).registerTypeAdapter(DatabaseSettings.URL.class, (Object)new DatabaseSettings.TypeAdapter()).registerTypeAdapter(DatabaseSettings.Explicit.class, (Object)new DatabaseSettings.TypeAdapter()).registerTypeAdapter(RedisSettings.class, (Object)new RedisSettings.TypeAdapter()).registerTypeAdapter(RedisSettings.URL.class, (Object)new RedisSettings.TypeAdapter()).registerTypeAdapter(RedisSettings.Explicit.class, (Object)new RedisSettings.TypeAdapter()).registerTypeAdapter(Formula.class, (Object)new Formula.TypeAdapter()).registerTypeAdapter(NumberListTypeAdapter.INTEGER.getType(), NumberListTypeAdapter.INTEGER).registerTypeAdapter(NumberListTypeAdapter.LONG.getType(), NumberListTypeAdapter.LONG).registerTypeAdapter(NumberListTypeAdapter.SHORT.getType(), NumberListTypeAdapter.SHORT).registerTypeAdapter(NumberListTypeAdapter.BYTE.getType(), NumberListTypeAdapter.BYTE).registerTypeAdapter(NumberListTypeAdapter.BIG_INTEGER.getType(), NumberListTypeAdapter.BIG_INTEGER).registerTypeAdapter(NumberListTypeAdapter.ATOMIC_INTEGER.getType(), NumberListTypeAdapter.ATOMIC_INTEGER).registerTypeAdapter(NumberListTypeAdapter.ATOMIC_LONG.getType(), NumberListTypeAdapter.ATOMIC_LONG).registerTypeAdapter(PlayerReference.class, (Object)new PlayerReference.TypeAdapter());
    protected Gson gson;
    protected boolean ready;
    protected final Map<String, Config<? extends Configuration>> configs;
    private File dir;

    private AtlantisConfig() {
        AtlantisPixelmon.registerTypeAdapters(this.gsonBuilder);
        this.gson = null;
        this.ready = false;
        this.configs = new ConcurrentHashMap<String, Config<? extends Configuration>>();
    }

    protected Optional<GsonBuilder> getGSONBuilder() {
        if (this.gsonBuilt) {
            return Optional.empty();
        }
        return Optional.of(this.gsonBuilder);
    }

    public static void registerTypeAdapters(String modID, Consumer<GsonBuilder> consumer) {
        AtlantisConfig.getInstance(modID).registerTypeAdapters(consumer);
    }

    public void registerTypeAdapters(Consumer<GsonBuilder> consumer) {
        this.getGSONBuilder().ifPresent(consumer);
    }

    public void buildGSON() {
        if (!this.gsonBuilt) {
            this.gsonBuilt = true;
            this.gson = this.gsonBuilder.create();
        }
    }

    public Gson getGSON() {
        this.buildGSON();
        return this.gson;
    }

    @Deprecated
    protected static void preRegistration(String modID) {
        INSTANCES.put(modID, AtlantisConfig.preRegistration0(modID));
    }

    @Deprecated
    protected static AtlantisConfig preRegistration0(String modID) {
        File root = new File(".");
        File all = new File(root, "config");
        all.mkdir();
        File config = new File(all, modID);
        AtlantisConfig instance = new AtlantisConfig();
        instance.dir = config;
        instance.dir.mkdir();
        return instance;
    }

    @Deprecated
    protected static <T extends Configuration> T getDuringRegistration(String modID, Class<? extends T> clazz) {
        Config<? extends Configuration> config = AtlantisConfig.getInstance((String)modID).configs.get(clazz.getCanonicalName());
        try {
            boolean result = config.read(true).get();
            if (!result) {
                config.write();
            }
            config.remapLang();
            return (T)config.get();
        }
        catch (InterruptedException | ExecutionException e) {
            AtlantisLogger.error("Failed immediate read of {}!", config.getName());
            return null;
        }
    }

    @Deprecated
    protected static void postRegistration(String modID) {
        AtlantisConfig instance = AtlantisConfig.getInstance(modID);
        ArrayList configs = Lists.newArrayList(instance.configs.values());
        configs.sort(Comparator.comparingInt(config -> config.getOrder().ordinal()));
        for (Config config2 : configs) {
            if (config2.isPlayerData() && !config2.shouldForceLoad()) continue;
            config2.read(true).whenComplete((r, err) -> config2.runTask(() -> config2.write()));
        }
        instance.ready = true;
        if ("atlantis".equalsIgnoreCase(modID)) {
            INIT.set(true);
        }
    }

    protected static AtlantisConfig getInstance(String modID) {
        return INSTANCES.computeIfAbsent(modID, key -> AtlantisConfig.preRegistration0(modID));
    }

    public static Collection<AtlantisConfig> getAllInstances() {
        return INSTANCES.values();
    }

    public static File getDir(String modID) {
        return AtlantisConfig.getInstance((String)modID).dir;
    }

    @Deprecated
    protected static <T extends Configuration> void register(String modID, String path, Class<? extends Configuration> clazz, Configuration instance, Storage storage, boolean forceLoad, boolean lang, boolean aon, LoadOrder order) {
        try {
            AtlantisConfig config = AtlantisConfig.getInstance(modID);
            Config<? extends Configuration> specific = new Config<Configuration>(config, modID, clazz.getCanonicalName(), config.getGSON(), instance, clazz, storage, forceLoad, lang, aon, order);
            ConfigEvent.Register<? extends Configuration> event = new ConfigEvent.Register<Configuration>(specific, path);
            Atlantis.EVENT_BUS.post(event);
            specific.init(event.getPath());
            config.configs.put(clazz.getCanonicalName(), specific);
            CLASS_TO_MOD.put(clazz, modID);
            if (specific.isPlayerData()) {
                PLAYER_CONFIGS.add(specific);
            }
        }
        catch (Exception e) {
            AtlantisLogger.info("Failed to instantiate new " + modID + ":" + clazz.getSimpleName() + ".", new Object[0]);
            e.printStackTrace();
        }
    }

    @Deprecated
    protected static <T extends Configuration> T get(String modID, Class<? extends T> clazz) {
        AtlantisConfig instance = AtlantisConfig.getInstance(modID);
        if (!instance.ready) {
            return AtlantisConfig.getDuringRegistration(modID, clazz);
        }
        Config<T> config = instance.getConfig(clazz.getCanonicalName());
        return config.get();
    }

    @Deprecated
    protected static <T extends Configuration> T getOrElse(String modID, Class<? extends T> clazz, T orElse) {
        AtlantisConfig instance = AtlantisConfig.getInstance(modID);
        if (instance == null || !instance.ready) {
            return orElse;
        }
        Config<T> config = instance.getConfig(clazz.getCanonicalName());
        T result = config.get();
        return result == null ? orElse : result;
    }

    @Deprecated
    protected static <T extends Configuration> Collection<T> getAll(String modID, Class<? extends T> clazz) {
        String className = clazz.getCanonicalName();
        Config<T> config = AtlantisConfig.getInstance(modID).getConfig(className);
        boolean first = true;
        int count = 2000;
        while (true) {
            if (count >= 2000) {
                if (!config.isBusy()) break;
                if (first) {
                    AtlantisLogger.info(modID + ":" + className + " is busy, waiting.", new Object[0]);
                    first = false;
                }
                count = 0;
            }
            ++count;
        }
        return config.getAll();
    }

    @Deprecated
    protected static boolean isBusy(String modID) {
        AtlantisConfig instance = AtlantisConfig.getInstance(modID);
        if (!instance.ready) {
            return true;
        }
        for (Config<? extends Configuration> config : instance.configs.values()) {
            if (!config.isBusy()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected static void enqueue(String modID, Runnable task) {
        if (AtlantisConfig.isBusy(modID)) {
            AtlantisConfig self = AtlantisConfig.getInstance(modID);
            if (self.scheduledTasks.isEmpty()) {
                self.scheduledTasks.add(task);
                Atlantis.THREAD_POOL.repeatUntilComplete(() -> {
                    if (AtlantisConfig.isBusy(modID)) {
                        return false;
                    }
                    for (Runnable scheduledTask : self.scheduledTasks) {
                        scheduledTask.run();
                    }
                    self.scheduledTasks.clear();
                    return true;
                }, Settings.getSettings().getScheduledTaskDelay());
            } else {
                self.scheduledTasks.add(task);
            }
        } else {
            task.run();
        }
    }

    @Deprecated
    protected static <T extends Configuration> boolean isBusy(String modID, Class<T> clazz) {
        Config<T> config = AtlantisConfig.getInstance(modID).getConfig(clazz.getCanonicalName());
        return config.isBusy();
    }

    @Deprecated
    protected static <T extends Configuration> void enqueue(String modID, Class<? extends T> clazz, Consumer<Collection<T>> task) {
        Config<T> config = AtlantisConfig.getInstance(modID).getConfig(clazz.getCanonicalName());
        config.runTask(task);
    }

    @Deprecated
    protected static <T extends Configuration> void put(String modID, Class<? extends T> clazz, T instance) {
        Config<T> config = AtlantisConfig.getInstance(modID).getConfig(clazz.getCanonicalName());
        config.put(instance);
    }

    @Deprecated
    protected static <T extends Configuration> Text format(String modID, Class<T> clazz, String key, Object ... args) {
        Config<T> config = AtlantisConfig.getInstance(modID).getConfig(clazz.getCanonicalName());
        if (config.isLang()) {
            return config.format(key, args);
        }
        return Text.empty();
    }

    @Deprecated
    protected static <T extends Configuration> CompletableFuture<T> getFor(String modID, Class<? extends T> clazz, UUID uuid) {
        Config<T> config = AtlantisConfig.getInstance(modID).getConfig(clazz.getCanonicalName());
        return config.get(AtlantisConfig.copyUUID(uuid));
    }

    @Deprecated
    protected static <T extends Configuration> CompletableFuture<T> getForOrPut(String modID, Class<? extends T> clazz, UUID uuid, Supplier<T> orElse) {
        Config config = AtlantisConfig.getInstance(modID).getConfig(clazz.getCanonicalName());
        return config.get(AtlantisConfig.copyUUID(uuid)).thenApply(instance -> {
            if (instance == null) {
                instance = (Configuration)orElse.get();
                config.put(instance);
                instance.save();
            }
            return instance;
        });
    }

    @Deprecated
    protected static <T extends Configuration> CompletableFuture<T> remove(String modID, Class<? extends T> clazz, UUID uuid) {
        Config<T> config = AtlantisConfig.getInstance(modID).getConfig(clazz.getCanonicalName());
        return config.remove(AtlantisConfig.copyUUID(uuid));
    }

    @Deprecated
    protected static <T extends Configuration> CompletableFuture<T> remove(String modID, Class<? extends T> clazz, String name) {
        Config<T> config = AtlantisConfig.getInstance(modID).getConfig(clazz.getCanonicalName());
        return config.remove(name);
    }

    @Deprecated
    protected static <T extends Configuration> T getFor(String modID, Class<? extends T> clazz, String name) {
        Config<T> config = AtlantisConfig.getInstance(modID).getConfig(clazz.getCanonicalName());
        return config.get(name);
    }

    @Deprecated
    protected static <T extends Configuration> T getFor(String modID, Class<? extends T> clazz, PlayerEntity player) {
        Config<T> config = AtlantisConfig.getInstance(modID).getConfig(clazz.getCanonicalName());
        return config.get(player);
    }

    @Deprecated
    protected static <T extends Configuration> void load(String modID, Class<? extends T> clazz) {
        Config<T> config = AtlantisConfig.getInstance(modID).getConfig(clazz.getCanonicalName());
        config.read();
    }

    @Deprecated
    protected static <T extends Configuration> void save(String modID, Class<? extends T> clazz) {
        Atlantis.THREAD_POOL.submit(() -> {
            Config config = AtlantisConfig.getInstance(modID).getConfig(clazz.getCanonicalName());
            config.write();
        });
    }

    @Deprecated
    protected static <T extends Configuration> void save(String modID, T data) {
        AtlantisConfig.save(modID, data, false);
    }

    @Deprecated
    protected static <T extends Configuration> void save(String modID, T data, boolean immediate) {
        Runnable writeTask = () -> {
            Config<Configuration> config = AtlantisConfig.getInstance(modID).getConfig(data.getClass().getName());
            config.write(data, immediate);
        };
        if (data instanceof PlayerData) {
            writeTask.run();
        } else {
            Atlantis.THREAD_POOL.submit(writeTask);
        }
    }

    @Deprecated
    protected static void loadAll(String modID, DataType type) {
        for (Config<? extends Configuration> config : AtlantisConfig.getInstance((String)modID).configs.values()) {
            if (!type.isValid(config)) continue;
            config.read();
        }
    }

    @Deprecated
    protected static void saveAll(String modID, DataType type) {
        Atlantis.THREAD_POOL.submit(() -> {
            for (Config<? extends Configuration> config : AtlantisConfig.getInstance((String)modID).configs.values()) {
                if (!type.isValid(config)) continue;
                config.write();
            }
        });
    }

    public <T extends Configuration> Config<T> getConfig(String key) {
        return Objects.requireNonNull(this.configs.get(key), "Invalid configuration type " + key);
    }

    public void destruct() {
        for (Config<? extends Configuration> config : this.configs.values()) {
            config.destruct();
        }
    }

    protected static UUID copyUUID(UUID uuid) {
        return new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static String getModForClass(Class<? extends Configuration> clazz) {
        return CLASS_TO_MOD.get(clazz);
    }

    public static void onPlayerJoin(ServerPlayerEntity player) {
        for (Config<? extends PlayerData> config : PLAYER_CONFIGS) {
            config.getStorage().onPlayerJoin(config, player);
        }
    }

    public static void onPlayerLeave(ServerPlayerEntity player) {
        for (Config<? extends PlayerData> config : PLAYER_CONFIGS) {
            config.getStorage().onPlayerLeave(config, player);
        }
    }

    protected static void asyncSave() {
        for (AtlantisConfig instance : INSTANCES.values()) {
            instance.asyncSaveInner();
        }
    }

    public void asyncSaveInner() {
        for (Config<? extends Configuration> config : this.configs.values()) {
            config.asyncSave();
        }
    }
}

