/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.file;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.waterdu.atlantis.file.AonComment;
import de.waterdu.atlantis.file.Config;
import de.waterdu.atlantis.file.datatypes.Configuration;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import de.waterdu.atlantis.util.text.TextUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class AonCommenter {
    private static final String NEWLINE = "\n";
    private static final Set<Class<? extends Configuration>> NOT_COMMENTED = Sets.newConcurrentHashSet();
    private static final Map<Class<? extends Configuration>, Info> INFO_MAP = Maps.newConcurrentMap();

    private AonCommenter() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static String comment(Config config, String json, Class<? extends Configuration> type) {
        Info info2;
        if (!config.isAON()) {
            return json;
        }
        if (NOT_COMMENTED.contains(type)) {
            return json;
        }
        if (INFO_MAP.containsKey(type)) {
            info2 = INFO_MAP.get(type);
        } else {
            AonComment root = type.getAnnotation(AonComment.class);
            if (root == null) {
                NOT_COMMENTED.add(type);
                return json;
            }
            info2 = new Info(root, type);
            INFO_MAP.put(type, info2);
        }
        return info2.comment(json);
    }

    public static String uncomment(Config config, String json, Class<? extends Configuration> type) {
        if (!config.isAON()) {
            return json;
        }
        if (NOT_COMMENTED.contains(type)) {
            return json;
        }
        if (json.startsWith("{")) {
            return json;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{").append(NEWLINE);
        ArrayList lines = Lists.newArrayList((Object[])json.trim().split(NEWLINE));
        int index = 0;
        for (String line : lines) {
            if (!line.trim().isEmpty() && !line.startsWith("#")) {
                boolean nextIsElement = AonCommenter.nextIsElement(lines, index);
                if (line.startsWith(" ") || !line.contains(":")) {
                    builder.append("  ").append(line);
                } else {
                    String[] split2 = line.split(":");
                    builder.append("  ").append("\"").append(split2[0]).append("\":").append(TextUtils.concat(1, ":", split2));
                }
                if (nextIsElement && !line.endsWith("[") && !line.endsWith("{")) {
                    builder.append(",");
                }
                builder.append(NEWLINE);
            }
            ++index;
        }
        builder.append("}");
        return builder.toString();
    }

    private static boolean nextIsElement(List<String> lines, int index) {
        if (index + 1 >= lines.size()) {
            return false;
        }
        for (int i = index + 1; i < lines.size(); ++i) {
            String line = lines.get(i).trim();
            if (line.isEmpty() || line.startsWith("#")) continue;
            return !line.equalsIgnoreCase("]") && !line.equalsIgnoreCase("}");
        }
        return false;
    }

    private static class Info {
        private final CommentHolder root;
        private final Map<String, Optional<CommentHolder>> comments = Maps.newHashMap();

        private Info(AonComment root, Class<? extends Configuration> type) {
            this.root = new CommentHolder(root);
            for (Field field : type.getDeclaredFields()) {
                AonComment comment = field.getAnnotation(AonComment.class);
                if (comment == null) continue;
                this.putComment(field.getName(), comment);
            }
        }

        public CommentHolder getRoot() {
            return this.root;
        }

        public Map<String, Optional<CommentHolder>> getComments() {
            return this.comments;
        }

        public void putComment(String field, AonComment comment) {
            this.comments.put(field, Optional.of(new CommentHolder(comment)));
        }

        public Optional<CommentHolder> getComment(String field) {
            return this.comments.getOrDefault(field, Optional.empty());
        }

        public String comment(String json) {
            String[] lines;
            StringBuilder builder = new StringBuilder();
            this.root.apply(builder);
            for (String line : lines = json.split(AonCommenter.NEWLINE)) {
                if (!line.startsWith("  ")) continue;
                if ((line = line.substring(2)).startsWith("  ") || !line.contains(":")) {
                    if (line.endsWith(",")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    builder.append(line);
                } else {
                    String[] split2 = line.split(":");
                    String last = split2[split2.length - 1];
                    if (last.endsWith(",")) {
                        split2[split2.length - 1] = last.substring(0, last.length() - 1);
                    }
                    String field = split2[0].replace("\"", "");
                    if (builder.length() > 0) {
                        builder.append(AonCommenter.NEWLINE);
                    }
                    this.getComment(field).ifPresent(comment -> ((CommentHolder)comment).apply(builder));
                    builder.append(field).append(":").append(TextUtils.concat(1, ":", split2));
                }
                builder.append(AonCommenter.NEWLINE);
            }
            return builder.toString();
        }

        private static class CommentHolder {
            private final String[] lines;
            private final int[] indents;

            private CommentHolder(AonComment comment) {
                this.lines = comment.value();
                this.indents = comment.indents();
            }

            private void apply(StringBuilder builder) {
                for (int i = 0; i < this.lines.length; ++i) {
                    int indent = this.indents.length > i ? this.indents[i] : 1;
                    String line = this.lines[i];
                    if (!line.isEmpty()) {
                        for (int j = 0; j < indent; ++j) {
                            builder.append("#");
                        }
                        builder.append(" ").append(line);
                    }
                    builder.append(AonCommenter.NEWLINE);
                }
            }
        }
    }
}

