/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.waterdu.atlantis.command.AtlantisCommand;
import de.waterdu.atlantis.util.entity.PermissionUtils;
import de.waterdu.atlantis.util.text.MessageUtils;
import de.waterdu.atlantis.util.text.Text;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.ITextComponent;

public class CommandBuilder {
    private final Node root;
    private final Map<Integer, Set<Node>> mappedNodes = Maps.newHashMap();
    private final List<ExecuteCondition> conditions = Lists.newArrayList();
    private final Supplier<String> name;
    private final Supplier<List<String>> aliases;
    private final Supplier<Object> noPerms;
    private final Supplier<Object> invalidArgs;

    private CommandBuilder(Supplier<String> name, Supplier<List<String>> aliases, Supplier<Object> noPerms, Supplier<Object> invalidArgs) {
        this.root = Node.create(this, null);
        this.name = name;
        this.aliases = aliases;
        this.noPerms = noPerms;
        this.invalidArgs = invalidArgs;
    }

    public static Node create(Supplier<String> name, Supplier<List<String>> aliases, Supplier<Object> noPerms, Supplier<Object> invalidArgs) {
        return new CommandBuilder(name, aliases, noPerms, invalidArgs).root;
    }

    public AtlantisCommand build() {
        return new AtlantisCommand(){

            @Override
            public String getName() {
                return (String)CommandBuilder.this.name.get();
            }

            @Override
            public List<String> getAliases() {
                return (List)CommandBuilder.this.aliases.get();
            }

            @Override
            public Optional<CompletableFuture<Suggestions>> tabCompletionCallback(CommandContext<CommandSource> context, SuggestionsBuilder builder, String ... args) throws CommandSyntaxException, NoPermissionException {
                Set nodes = (Set)CommandBuilder.this.mappedNodes.get(args.length);
                if (nodes != null) {
                    for (Node node : nodes) {
                        if (!node.permission.isEmpty() && !PermissionUtils.hasPermission((CommandSource)context.getSource(), node.permission)) continue;
                        boolean validFamily = true;
                        for (Node parent : node.family()) {
                            if (parent.test.test(context, parent.permission, parent.depth == 0 ? "" : args[parent.depth - 1], args)) continue;
                            validFamily = false;
                            break;
                        }
                        if (!validFamily) continue;
                        node.completion.build(context, builder, args);
                    }
                }
                return Optional.of(builder.buildFuture());
            }

            @Override
            public void execute(CommandContext<CommandSource> context, String ... args) throws CommandException {
                try {
                    for (ExecuteCondition condition : CommandBuilder.this.conditions) {
                        if (condition.check(context, args)) continue;
                        return;
                    }
                }
                catch (NoPermissionException e1) {
                    MessageUtils.send(CommandBuilder.this.noPerms.get(), (CommandSource)context.getSource());
                    return;
                }
                catch (CommandSyntaxException | InvalidArgsException e2) {
                    MessageUtils.send(CommandBuilder.this.invalidArgs.get(), (CommandSource)context.getSource());
                    return;
                }
                boolean done = false;
                Set nodes = (Set)CommandBuilder.this.mappedNodes.get(0);
                block7: while (!done) {
                    Node node;
                    done = true;
                    if (nodes == null || nodes.isEmpty()) continue;
                    Iterator iterator = nodes.iterator();
                    while (iterator.hasNext() && (node = (Node)iterator.next()).depth <= args.length) {
                        try {
                            if (!node.test.test(context, node.permission, node.depth == 0 ? "" : args[node.depth - 1], args)) continue;
                            if (node.depth == args.length) {
                                node.execute.execute(context, args);
                                return;
                            }
                            nodes = node.children;
                            done = false;
                        }
                        catch (NoPermissionException e1) {
                            MessageUtils.send(CommandBuilder.this.noPerms.get(), (CommandSource)context.getSource());
                        }
                        catch (CommandSyntaxException | InvalidArgsException e2) {
                            MessageUtils.send(CommandBuilder.this.invalidArgs.get(), (CommandSource)context.getSource());
                        }
                        continue block7;
                    }
                }
                MessageUtils.send(CommandBuilder.this.invalidArgs.get(), (CommandSource)context.getSource());
            }
        };
    }

    public static class NoPermissionException
    extends Exception {
    }

    public static class InvalidArgsException
    extends Exception {
    }

    @FunctionalInterface
    public static interface Execute {
        public static final Execute DO_NOTHING = (context, args) -> {};

        public void execute(CommandContext<CommandSource> var1, String ... var2) throws InvalidArgsException, NoPermissionException, CommandException, CommandSyntaxException;
    }

    @FunctionalInterface
    public static interface ExecuteCondition {
        public static final ExecuteCondition DO_NOTHING = (context, args) -> true;

        public boolean check(CommandContext<CommandSource> var1, String ... var2) throws InvalidArgsException, NoPermissionException, CommandException, CommandSyntaxException;
    }

    @FunctionalInterface
    public static interface Completion {
        public static final Completion EMPTY = (context, builder, args) -> builder.buildFuture();

        public static Completion of(Collection<String> options) {
            return Completion.of(options.toArray(new String[0]));
        }

        public static Completion of(String ... options) {
            return Completion.of(() -> options);
        }

        public static Completion of(Supplier<String[]> options) {
            return (context, builder, args) -> {
                for (String option : (String[])options.get()) {
                    if (args.length == 0) {
                        builder.suggest(option);
                        continue;
                    }
                    String currentWord = args[args.length - 1];
                    if (currentWord.isEmpty() || currentWord.equals(" ")) {
                        builder.suggest(option);
                        continue;
                    }
                    if (!option.toLowerCase().startsWith(currentWord.toLowerCase())) continue;
                    builder.suggest(option);
                }
            };
        }

        public void build(CommandContext<CommandSource> var1, SuggestionsBuilder var2, String ... var3);
    }

    @FunctionalInterface
    public static interface Test {
        public static final Test TRUE = (context, permission, arg, args) -> true;
        public static final Test FALSE = (context, permission, arg, args) -> false;
        public static final Test HAS_PERMISSION = (context, permission, arg, args) -> {
            if (permission.isEmpty()) {
                return true;
            }
            if (PermissionUtils.hasPermission((CommandSource)context.getSource(), permission)) {
                return true;
            }
            throw new NoPermissionException();
        };

        public static Test matches(String ... options) {
            return Test.matches(() -> options);
        }

        public static Test matchesAndHasPermission(String ... options) {
            return Test.matchesAndHasPermission(() -> options);
        }

        public static Test matches(Supplier<String[]> options) {
            return (context, permission, arg, args) -> {
                for (String option : (String[])options.get()) {
                    if (!option.equalsIgnoreCase(arg)) continue;
                    return true;
                }
                return false;
            };
        }

        public static Test matchesAndHasPermission(Supplier<String[]> options) {
            return (context, permission, arg, args) -> Test.matches(options).test((CommandContext<CommandSource>)context, permission, arg, args) && HAS_PERMISSION.test((CommandContext<CommandSource>)context, permission, arg, args);
        }

        public boolean test(CommandContext<CommandSource> var1, String var2, String var3, String ... var4) throws NoPermissionException;
    }

    public static class Node {
        private final CommandBuilder builder;
        private final Node parent;
        private final Set<Node> children;
        private final List<Node> family;
        private final int depth;
        private String permission = "";
        private Test test = Test.HAS_PERMISSION;
        private Completion completion = Completion.EMPTY;
        private Execute execute = Execute.DO_NOTHING;

        private Node(CommandBuilder builder, Node parent) {
            this.builder = builder;
            this.parent = parent;
            this.children = Sets.newHashSet();
            if (parent == null) {
                this.family = Lists.newArrayList();
            } else {
                this.family = Lists.newArrayList(parent.family);
                this.family.add(parent);
            }
            this.depth = parent == null ? 0 : parent.depth + 1;
        }

        private static Node create(CommandBuilder executor, Node parent) {
            Node node = new Node(executor, parent);
            executor.mappedNodes.computeIfAbsent(node.depth, depth -> Sets.newHashSet()).add(node);
            return node;
        }

        public Node permission(String permission) {
            this.permission = permission;
            return this;
        }

        public Node test(Test test) {
            this.test = test;
            return this;
        }

        public Node completion(Completion completion) {
            this.completion = completion;
            return this;
        }

        public Node condition(ExecuteCondition condition) {
            this.builder.conditions.add(condition);
            return this;
        }

        public Node execute(Execute execute) {
            this.execute = execute;
            return this;
        }

        public Node child() {
            Node child = Node.create(this.builder, this);
            this.children.add(child);
            return child;
        }

        public Node parent() {
            if (this.parent == null) {
                throw new CommandException((ITextComponent)Text.of("Tried to get parent of root node!").compile());
            }
            return this.parent;
        }

        public List<Node> family() {
            return this.family;
        }

        public AtlantisCommand done() {
            return this.builder.build();
        }
    }
}

