/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.waterdu.atlantis.command.CommandBuilder;
import de.waterdu.atlantis.util.server.ServerUtils;
import de.waterdu.atlantis.util.text.MessageUtils;
import de.waterdu.atlantis.util.text.Text;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;

public abstract class AtlantisCommand {
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    private static final List<String> EMPTY_LIST = Lists.newArrayListWithCapacity((int)0);

    public abstract String getName();

    public String getUsage(CommandSource source) {
        return "/" + this.getName();
    }

    public int getRequiredPermissionLevel() {
        return 0;
    }

    private boolean hasPermission(CommandSource source) {
        return source.func_197034_c(this.getRequiredPermissionLevel());
    }

    public boolean checkPermission(MinecraftServer server, CommandSource source) {
        return true;
    }

    public abstract void execute(CommandContext<CommandSource> var1, String ... var2) throws CommandException, CommandSyntaxException;

    private int handleExecution(CommandContext<CommandSource> context) {
        try {
            this.execute(context, ((String)context.getArgument("", String.class)).split(" "));
            return 1;
        }
        catch (IllegalArgumentException e) {
            try {
                this.execute(context, new String[0]);
                return 1;
            }
            catch (CommandException e2) {
                ((CommandSource)context.getSource()).func_197030_a(e2.func_197003_a(), false);
                return 0;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return 0;
            }
        }
        catch (CommandException e) {
            ((CommandSource)context.getSource()).func_197030_a(e.func_197003_a(), false);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public List<String> getTabCompletions(CommandContext<CommandSource> context, SuggestionsBuilder builder, String[] args) throws CommandSyntaxException {
        return EMPTY_LIST;
    }

    public Optional<CompletableFuture<Suggestions>> tabCompletionCallback(CommandContext<CommandSource> context, SuggestionsBuilder builder, String[] args) throws CommandSyntaxException, CommandBuilder.NoPermissionException {
        return Optional.empty();
    }

    private CompletableFuture<Suggestions> buildSuggestions(CommandContext<CommandSource> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        Optional<CompletableFuture<Suggestions>> shortCircuit;
        List<String> tabCompletions;
        String[] initialArgs = context.getInput().split(" ");
        ArrayList args = Lists.newArrayList((Object[])Arrays.copyOfRange(initialArgs, 1, initialArgs.length));
        int space = 0;
        Matcher matcher = SPACE_PATTERN.matcher(context.getInput());
        while (matcher.find()) {
            ++space;
        }
        while (space > args.size()) {
            args.add(" ");
            --space;
        }
        String[] argsArray = args.toArray(new String[0]);
        try {
            tabCompletions = this.getTabCompletions(context, builder, argsArray);
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return builder.buildFuture();
        }
        builder = args.size() > 0 && !((String)args.get(args.size() - 1)).trim().isEmpty() ? builder.createOffset(context.getInput().length() - ((String)args.get(args.size() - 1)).length()) : builder.createOffset(context.getInput().length());
        try {
            shortCircuit = this.tabCompletionCallback(context, builder, argsArray);
        }
        catch (CommandBuilder.NoPermissionException e) {
            e.printStackTrace();
            return builder.buildFuture();
        }
        if (shortCircuit.isPresent()) {
            return shortCircuit.get();
        }
        for (String tabCompletion : tabCompletions) {
            if (args.isEmpty()) {
                builder.suggest(tabCompletion);
                continue;
            }
            String currentWord = (String)args.get(args.size() - 1);
            if (currentWord.isEmpty() || currentWord.equals(" ")) {
                builder.suggest(tabCompletion);
                continue;
            }
            if (!tabCompletion.toLowerCase().startsWith(currentWord.toLowerCase())) continue;
            builder.suggest(tabCompletion);
        }
        return builder.buildFuture();
    }

    public List<String> getAliases() {
        return Lists.newArrayList();
    }

    public final boolean match(String arg, String ... matches) {
        for (String b : matches) {
            if (!arg.equalsIgnoreCase(b)) continue;
            return true;
        }
        return false;
    }

    public final void send(CommandSource source, Text message) {
        MessageUtils.send(message, source);
    }

    public final void send(CommandSource source, String message) {
        MessageUtils.send(message, source);
    }

    public final void send(CommandSource source, ITextComponent message) {
        MessageUtils.send(message, source);
    }

    public final void getPlayersOrElse(CommandSource source, String arg, Consumer<List<ServerPlayerEntity>> success, Runnable failure) throws CommandSyntaxException {
        List players;
        if (arg.contains("@")) {
            players = new EntitySelectorParser(new StringReader(arg)).func_201345_m().func_197342_d(source);
        } else {
            players = Lists.newArrayList();
            ServerUtils.getPlayer(arg).ifPresent(players::add);
        }
        if (!players.isEmpty()) {
            success.accept(players);
        } else {
            failure.run();
        }
    }

    public void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)this.getName()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"", (ArgumentType)StringArgumentType.greedyString()).requires(this::hasPermission)).suggests(this::buildSuggestions).executes(this::handleExecution))).executes(context -> {
            this.execute((CommandContext<CommandSource>)context, new String[0]);
            return 1;
        });
        LiteralCommandNode args = dispatcher.register(builder);
        for (String alias : this.getAliases()) {
            dispatcher.getRoot().addChild(AtlantisCommand.buildRedirect(alias, (LiteralCommandNode<CommandSource>)args));
        }
    }

    private static LiteralCommandNode<CommandSource> buildRedirect(String alias, LiteralCommandNode<CommandSource> destination) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alias.toLowerCase(Locale.ENGLISH)).requires(destination.getRequirement())).forward(destination.getRedirect(), destination.getRedirectModifier(), destination.isFork())).executes(destination.getCommand());
        for (CommandNode child : destination.getChildren()) {
            builder.then(child);
        }
        return builder.build();
    }
}

