/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.comm;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.waterdu.atlantis.comm.Query;
import de.waterdu.atlantis.playerdata.PlayerData;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class UsernameQuery
implements Query<String> {
    private PlayerData pd;
    private final UUID uuid;
    private final CompletableFuture<String> result;

    private UsernameQuery(UUID uuid) {
        this.uuid = uuid;
        this.result = new CompletableFuture();
    }

    public static UsernameQuery from(UUID uuid) {
        return new UsernameQuery(uuid);
    }

    public UsernameQuery to(PlayerData pd) {
        this.pd = pd;
        return this;
    }

    @Override
    public void run() {
        String name = "";
        try {
            String addr = "https://sessionserver.mojang.com/session/minecraft/profile/" + this.uuid.toString().replace("-", "") + "?unsigned=false";
            URL url = new URL(addr);
            try (InputStreamReader input = new InputStreamReader(url.openStream());
                 BufferedReader reader = new BufferedReader(input);){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                JsonParser parser = new JsonParser();
                JsonElement obj = parser.parse(sb.toString().trim());
                name = obj.getAsJsonObject().get("name").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!name.isEmpty()) {
            if (this.pd != null) {
                this.pd.setNameAndUpdate(name);
                this.pd.save();
            }
            this.result.complete(name);
        } else {
            this.result.complete("");
        }
    }

    @Override
    public CompletableFuture<String> getResult() {
        return this.result;
    }
}

