/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.comm;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.waterdu.atlantis.comm.Query;
import de.waterdu.atlantis.playerdata.PlayerData;
import de.waterdu.atlantis.util.java.UUIDUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class UUIDQuery
implements Query<UUID> {
    private PlayerData pd;
    private final String name;
    private final CompletableFuture<UUID> result;

    private UUIDQuery(String name) {
        this.name = name;
        this.result = new CompletableFuture();
    }

    public static UUIDQuery from(String name) {
        return new UUIDQuery(name);
    }

    public UUIDQuery to(PlayerData pd) {
        this.pd = pd;
        return this;
    }

    @Override
    public void run() {
        UUID uuid = null;
        try {
            String addr = "https://api.mojang.com/users/profiles/minecraft/" + this.name;
            URL url = new URL(addr);
            try (InputStreamReader input = new InputStreamReader(url.openStream());
                 BufferedReader reader = new BufferedReader(input);){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                JsonParser parser = new JsonParser();
                JsonElement obj = parser.parse(sb.toString().trim());
                uuid = UUIDUtils.fromString(obj.getAsJsonObject().get("id").getAsString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uuid != null) {
            if (this.pd != null) {
                this.pd.setUUID(uuid);
                this.pd.save();
            }
            this.result.complete(uuid);
        } else {
            this.result.complete(null);
        }
    }

    @Override
    public CompletableFuture<UUID> getResult() {
        return this.result;
    }
}

