/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.comm;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.waterdu.atlantis.comm.Query;
import de.waterdu.atlantis.comm.Skin;
import de.waterdu.atlantis.playerdata.PlayerData;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class SkinQuery
implements Query<Skin> {
    private PlayerData pd;
    private final UUID uuid;
    private final CompletableFuture<Skin> result;

    private SkinQuery(UUID uuid) {
        this.uuid = uuid;
        this.result = new CompletableFuture();
    }

    public static SkinQuery from(UUID uuid) {
        return new SkinQuery(uuid);
    }

    public SkinQuery to(PlayerData pd) {
        this.pd = pd;
        return this;
    }

    @Override
    public void run() {
        String skin = "";
        String signature = "";
        try {
            JsonParser parser = new JsonParser();
            String addr = "https://sessionserver.mojang.com/session/minecraft/profile/" + this.uuid.toString().replace("-", "") + "?unsigned=false";
            URL url = new URL(addr);
            try (InputStreamReader input = new InputStreamReader(url.openStream());
                 BufferedReader reader = new BufferedReader(input);){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                JsonObject obj = parser.parse(sb.toString()).getAsJsonObject();
                JsonArray properties = obj.get("properties").getAsJsonArray();
                String value = "";
                for (JsonElement property : properties) {
                    JsonObject propertyObject;
                    if (!property.isJsonObject() || !(propertyObject = property.getAsJsonObject()).get("name").getAsString().equalsIgnoreCase("textures")) continue;
                    value = propertyObject.get("value").getAsString();
                    signature = propertyObject.get("signature").getAsString();
                    break;
                }
                if (!value.isEmpty()) {
                    obj = parser.parse(new String(Base64.getDecoder().decode(value))).getAsJsonObject();
                    String skinURL = obj.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
                    byte[] skinByte = ("{\"signatureRequired\":" + (signature.isEmpty() ? "false" : "true") + ",\"textures\":{\"SKIN\":{\"url\":\"" + skinURL + "\"}}}").getBytes();
                    skin = new String(Base64.getEncoder().encode(skinByte));
                }
            }
        }
        catch (Exception parser) {
            // empty catch block
        }
        if (!skin.isEmpty()) {
            Skin skinObject = new Skin(skin, signature);
            if (this.pd != null) {
                this.pd.setSkinObject(skinObject);
                this.pd.save();
            }
            this.result.complete(skinObject);
        } else {
            this.result.complete(new Skin());
        }
    }

    @Override
    public CompletableFuture<Skin> getResult() {
        return this.result;
    }
}

