/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.comm;

import de.waterdu.atlantis.comm.MojangAPI;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public interface Query<T>
extends Runnable {
    public CompletableFuture<T> getResult();

    default public CompletableFuture<T> query() {
        return MojangAPI.query(this);
    }

    default public Optional<T> getPossibleResult() {
        try {
            return this.getResult().isDone() ? Optional.ofNullable(this.getResult().get()) : Optional.empty();
        }
        catch (InterruptedException | ExecutionException e) {
            return Optional.empty();
        }
    }

    default public void whenComplete(Consumer<T> action) {
        this.getResult().whenComplete((T result, U err) -> action.accept(result));
    }

    default public boolean isDone() {
        return this.getResult().isDone();
    }

    default public boolean isCancelled() {
        return this.getResult().isCancelled();
    }
}

