/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis;

import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AtlantisLogger {
    private static final Logger LOGGER = LogManager.getLogger((String)"Atlantis");

    private AtlantisLogger() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static void log(Severity severity, String message, Object ... args) {
        switch (severity) {
            case ERROR: {
                AtlantisLogger.error(message, args);
                return;
            }
            case WARN: {
                AtlantisLogger.warn(message, args);
                return;
            }
            case INFO_FORCED: {
                AtlantisLogger.infoForced(message, args);
                return;
            }
            case INFO: {
                AtlantisLogger.info(message, args);
                return;
            }
            case DEBUG: {
                AtlantisLogger.debug(message, args);
                return;
            }
        }
    }

    public static void info(String message, Object ... args) {
        if (Settings.getSettings().isHideLoadMessages()) {
            AtlantisLogger.debug(message, args);
        } else {
            AtlantisLogger.infoForced(message, args);
        }
    }

    public static void infoForced(String message, Object ... args) {
        LOGGER.info(message, args);
    }

    public static void warn(String message, Object ... args) {
        LOGGER.warn(message, args);
    }

    public static void error(String message, Object ... args) {
        LOGGER.error(message, args);
    }

    public static void debug(String message, Object ... args) {
        LOGGER.debug(message, args);
    }

    public static enum Severity {
        ERROR,
        WARN,
        INFO_FORCED,
        INFO,
        DEBUG;

    }
}

