/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis;

import com.mojang.brigadier.CommandDispatcher;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.command.AtlantisCommand;
import de.waterdu.atlantis.file.AtlantisConfig;
import de.waterdu.atlantis.file.AtlantisConfigFinder;
import de.waterdu.atlantis.file.AtlantisConfigProxy;
import de.waterdu.atlantis.file.AtlantisData;
import de.waterdu.atlantis.occasion.OccasionManager;
import de.waterdu.atlantis.pixelmon.AtlantisPixelmon;
import de.waterdu.atlantis.playerdata.UUIDNameCache;
import de.waterdu.atlantis.trident.Trident;
import de.waterdu.atlantis.ui.api.AtlantisUI;
import de.waterdu.atlantis.ui.api.PageOptions;
import de.waterdu.atlantis.util.concurrency.AtlantisThreadPool;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.network.NetworkUtils;
import de.waterdu.atlantis.util.server.ServerUtils;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="atlantis")
public class Atlantis {
    public static final String ID = "atlantis";
    public static final String NAME = "Atlantis";
    public static final String VERSION = "6.6.3";
    public static final String UPDATE = "https://waterdu.de/atlantis/update.json";
    public static final AtlantisThreadPool THREAD_POOL;
    public static final String WATERDUDE_NAME = "Waterdude";
    public static final String[] WATERDUDE_NAME_AS_ARRAY;
    public static final UUID WATERDUDE_UUID;
    public static final String ERROR_TEXT = "An internal error has occurred in Atlantis! Please inform your server administrator of this!";
    public static final IFormattableTextComponent ERROR_MESSAGE;
    public static Atlantis INSTANCE;
    public static AtlantisConfigProxy.Impl CONFIG;
    public static final IEventBus EVENT_BUS;

    public Atlantis() {
        INSTANCE = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(Atlantis::init);
        bus.addListener(Atlantis::startingServer);
        bus.addListener(Atlantis::startingClient);
        AtlantisConfigFinder.find();
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        AtlantisUI.register();
        AtlantisData.register();
        Trident.init(event);
        Trident.registerModLoadingContext();
        OccasionManager.register();
        PageOptions.FormFactor.createDefaults();
        AtlantisLogger.infoForced("Welcome to Atlantis 6.6.3", new Object[0]);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        this.registerCommand((CommandDispatcher<CommandSource>)event.getDispatcher(), Trident.COMMAND);
    }

    private void registerCommand(CommandDispatcher<CommandSource> dispatcher, AtlantisCommand command) {
        command.register(dispatcher);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void login(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            UUIDNameCache.add((PlayerEntity)player);
            PlayerReference.getSafely(event.getPlayer()).ifPresent(PlayerReference::reset);
            AtlantisConfig.onPlayerJoin(player);
            NetworkUtils.addAddress(player);
            Trident.login(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void changeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            PlayerReference.getSafely(event.getPlayer()).ifPresent(PlayerReference::reset);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void logout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            AtlantisConfig.onPlayerLeave(player);
            PlayerReference.getSafely(event.getPlayer()).ifPresent(PlayerReference::reset);
        }
    }

    @SubscribeEvent
    public static void startingClient(FMLClientSetupEvent event) {
        AtlantisConfigFinder.init(true);
    }

    @SubscribeEvent
    public static void startingServer(FMLDedicatedServerSetupEvent event) {
        AtlantisConfigFinder.init(true);
    }

    @SubscribeEvent
    public void stoppingServer(FMLServerStoppingEvent event) {
        for (AtlantisConfig config : AtlantisConfig.getAllInstances()) {
            config.asyncSaveInner();
        }
    }

    public static boolean isWaterdude(PlayerEntity player) {
        return player.func_110124_au().equals(WATERDUDE_UUID);
    }

    public static boolean isWaterdudeOnline() {
        return ServerUtils.getPlayer(WATERDUDE_UUID).isPresent();
    }

    static {
        AtlantisPixelmon.register();
        THREAD_POOL = AtlantisThreadPool.createNewThreadPool(NAME, 8, true);
        WATERDUDE_NAME_AS_ARRAY = new String[]{WATERDUDE_NAME};
        WATERDUDE_UUID = UUID.fromString("04e10682-dfe3-4c2f-9bcb-5e04ec7b647d");
        ERROR_MESSAGE = new StringTextComponent(TextFormatting.DARK_RED + ERROR_TEXT);
        CONFIG = AtlantisConfigProxy.of(ID);
        EVENT_BUS = BusBuilder.builder().build();
    }
}

