/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.tile;

import com.refinedmods.refinedstorage.RSTiles;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorage;
import com.refinedmods.refinedstorage.apiimpl.network.node.ExternalStorageNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.tile.NetworkNodeTile;
import com.refinedmods.refinedstorage.tile.config.IAccessType;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IPrioritizable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.tile.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.tile.data.RSSerializers;
import com.refinedmods.refinedstorage.tile.data.TileDataParameter;
import com.refinedmods.refinedstorage.util.WorldUtils;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;

public class ExternalStorageTile
extends NetworkNodeTile<ExternalStorageNetworkNode> {
    public static final TileDataParameter<Integer, ExternalStorageTile> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer, ExternalStorageTile> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer, ExternalStorageTile> WHITELIST_BLACKLIST = IWhitelistBlacklist.createParameter();
    public static final TileDataParameter<Integer, ExternalStorageTile> TYPE = IType.createParameter();
    public static final TileDataParameter<AccessType, ExternalStorageTile> ACCESS_TYPE = IAccessType.createParameter();
    public static final TileDataParameter<Long, ExternalStorageTile> STORED = new TileDataParameter<Long, ExternalStorageTile>(RSSerializers.LONG_SERIALIZER, 0L, t -> {
        long stored = 0L;
        for (IExternalStorage<ItemStack> iExternalStorage : ((ExternalStorageNetworkNode)t.getNode()).getItemStorages()) {
            stored += (long)iExternalStorage.getStored();
        }
        for (IExternalStorage<ItemStack> iExternalStorage : ((ExternalStorageNetworkNode)t.getNode()).getFluidStorages()) {
            stored += (long)iExternalStorage.getStored();
        }
        return stored;
    });
    public static final TileDataParameter<Long, ExternalStorageTile> CAPACITY = new TileDataParameter<Long, ExternalStorageTile>(RSSerializers.LONG_SERIALIZER, 0L, t -> {
        long capacity = 0L;
        for (IExternalStorage<ItemStack> iExternalStorage : ((ExternalStorageNetworkNode)t.getNode()).getItemStorages()) {
            capacity += iExternalStorage.getCapacity();
        }
        for (IExternalStorage<ItemStack> iExternalStorage : ((ExternalStorageNetworkNode)t.getNode()).getFluidStorages()) {
            capacity += iExternalStorage.getCapacity();
        }
        return capacity;
    });
    public static final TileDataParameter<CompoundNBT, ExternalStorageTile> COVER_MANAGER = new TileDataParameter<CompoundNBT, ExternalStorageTile>(DataSerializers.field_192734_n, new CompoundNBT(), t -> ((ExternalStorageNetworkNode)t.getNode()).getCoverManager().writeToNbt(), (t, v) -> ((ExternalStorageNetworkNode)t.getNode()).getCoverManager().readFromNbt((CompoundNBT)v), (initial, p) -> {});

    public ExternalStorageTile() {
        super(RSTiles.EXTERNAL_STORAGE);
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(WHITELIST_BLACKLIST);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(CAPACITY);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(ACCESS_TYPE);
        this.dataManager.addWatchedParameter(COVER_MANAGER);
    }

    @Override
    @Nonnull
    public ExternalStorageNetworkNode createNode(World world, BlockPos pos) {
        return new ExternalStorageNetworkNode(world, pos);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(CoverManager.PROPERTY, (Object)((ExternalStorageNetworkNode)this.getNode()).getCoverManager()).build();
    }

    @Override
    public CompoundNBT writeUpdate(CompoundNBT tag) {
        super.writeUpdate(tag);
        tag.func_218657_a(CoverManager.NBT_COVER_MANAGER, (INBT)((ExternalStorageNetworkNode)this.getNode()).getCoverManager().writeToNbt());
        return tag;
    }

    @Override
    public void readUpdate(CompoundNBT tag) {
        super.readUpdate(tag);
        ((ExternalStorageNetworkNode)this.getNode()).getCoverManager().readFromNbt(tag.func_74775_l(CoverManager.NBT_COVER_MANAGER));
        this.requestModelDataUpdate();
        WorldUtils.updateBlock(this.field_145850_b, this.field_174879_c);
    }
}

