/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.refinedmods.refinedstorage.RSKeyBindings;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.integration.jei.JeiIntegration;
import com.refinedmods.refinedstorage.integration.jei.RSJeiPlugin;
import com.refinedmods.refinedstorage.render.RenderSettings;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class SearchWidget
extends TextFieldWidget {
    private static final List<String> HISTORY = new ArrayList<String>();
    private int mode;
    private int historyIndex;

    public SearchWidget(FontRenderer fontRenderer, int x, int y, int width) {
        fontRenderer.getClass();
        super(fontRenderer, x, y, width, 9, (ITextComponent)new StringTextComponent(""));
        this.historyIndex = -1;
        this.func_146185_a(false);
        this.func_146189_e(true);
        this.func_146193_g(RenderSettings.INSTANCE.getSecondaryColor());
    }

    public void updateJei() {
        if (this.canSyncToJEINow()) {
            RSJeiPlugin.getRuntime().getIngredientFilter().setFilterText(this.func_146179_b());
        }
    }

    private boolean canSyncToJEINow() {
        return IGrid.doesSearchBoxModeUseJEI(this.mode) && JeiIntegration.isLoaded();
    }

    private boolean canSyncFromJEINow() {
        return (this.mode == 4 || this.mode == 5) && JeiIntegration.isLoaded();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        boolean clickedWidget;
        boolean wasFocused = this.func_230999_j_();
        boolean result = super.func_231044_a_(mouseX, mouseY, mouseButton);
        boolean bl = clickedWidget = mouseX >= (double)this.field_230690_l_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY >= (double)this.field_230691_m_ && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_);
        if (clickedWidget && mouseButton == 1) {
            this.func_146180_a("");
            this.func_230996_d_(true);
        } else if (wasFocused != this.func_230999_j_()) {
            this.saveHistory();
        }
        return result;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifier) {
        boolean result = super.func_231046_a_(keyCode, scanCode, modifier);
        if (this.func_230999_j_()) {
            if (keyCode == 265) {
                this.updateHistory(-1);
                result = true;
            } else if (keyCode == 264) {
                this.updateHistory(1);
                result = true;
            } else if (keyCode == 257 || keyCode == 335) {
                this.saveHistory();
                if (this.field_146212_n) {
                    this.func_230996_d_(false);
                }
                result = true;
            } else if (keyCode == 256) {
                this.saveHistory();
                if (!this.field_146212_n) {
                    this.func_230996_d_(false);
                    result = false;
                } else {
                    this.func_230996_d_(false);
                    result = true;
                }
            }
        }
        if (BaseScreen.isKeyDown(RSKeyBindings.FOCUS_SEARCH_BAR) && this.field_146212_n) {
            this.func_230996_d_(!this.func_230999_j_());
            this.saveHistory();
            result = true;
        }
        return result;
    }

    private void updateHistory(int delta) {
        if (HISTORY.isEmpty()) {
            return;
        }
        if (this.historyIndex == -1) {
            this.historyIndex = HISTORY.size();
        }
        this.historyIndex += delta;
        if (this.historyIndex < 0) {
            this.historyIndex = 0;
        } else if (this.historyIndex > HISTORY.size() - 1) {
            this.historyIndex = HISTORY.size() - 1;
            if (delta == 1) {
                this.func_146180_a("");
                return;
            }
        }
        this.func_146180_a(HISTORY.get(this.historyIndex));
    }

    private void saveHistory() {
        if (!HISTORY.isEmpty() && HISTORY.get(HISTORY.size() - 1).equals(this.func_146179_b())) {
            return;
        }
        if (!this.func_146179_b().trim().isEmpty()) {
            HISTORY.add(this.func_146179_b());
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.func_146205_d(!IGrid.isSearchBoxModeWithAutoselection(mode));
        this.func_230996_d_(IGrid.isSearchBoxModeWithAutoselection(mode));
        if (this.canSyncFromJEINow()) {
            this.setTextFromJEI();
        }
    }

    private void setTextFromJEI() {
        String filterText = RSJeiPlugin.getRuntime().getIngredientFilter().getFilterText();
        if (!this.func_146179_b().equals(filterText)) {
            this.func_146180_a(filterText);
        }
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.canSyncFromJEINow() && RSJeiPlugin.getRuntime().getIngredientListOverlay().hasKeyboardFocus()) {
            this.setTextFromJEI();
        }
        super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

