/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid.sorting;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.screen.grid.sorting.IGridSorter;
import com.refinedmods.refinedstorage.screen.grid.sorting.SortingDirection;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fluids.FluidStack;

public class IdGridSorter
implements IGridSorter {
    @Override
    public boolean isApplicable(IGrid grid) {
        return grid.getSortingType() == 2;
    }

    @Override
    public int compare(IGridStack left, IGridStack right, SortingDirection sortingDirection) {
        int leftId = 0;
        int rightId = 0;
        if (left.getIngredient() instanceof ItemStack && right.getIngredient() instanceof ItemStack) {
            leftId = Item.func_150891_b((Item)((ItemStack)left.getIngredient()).func_77973_b());
            rightId = Item.func_150891_b((Item)((ItemStack)right.getIngredient()).func_77973_b());
        } else if (left.getIngredient() instanceof FluidStack && right.getIngredient() instanceof FluidStack) {
            leftId = Registry.field_212619_h.func_148757_b((Object)((FluidStack)left.getIngredient()).getFluid());
            rightId = Registry.field_212619_h.func_148757_b((Object)((FluidStack)right.getIngredient()).getFluid());
        }
        if (leftId != rightId) {
            if (sortingDirection == SortingDirection.DESCENDING) {
                return Integer.compare(leftId, rightId);
            }
            if (sortingDirection == SortingDirection.ASCENDING) {
                return Integer.compare(rightId, leftId);
            }
        }
        return 0;
    }
}

