/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.recipe;

import com.google.common.collect.Lists;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.item.CoverItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class CoverRecipe
extends SpecialRecipe {
    public static IRecipeSerializer<CoverRecipe> SERIALIZER = new SpecialRecipeSerializer(CoverRecipe::new);

    public CoverRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public static boolean stackMatches(ItemStack first) {
        return CoverManager.isValidCover(first);
    }

    public static boolean matches(List<ItemStack> list) {
        return list.size() == 2;
    }

    public static ItemStack getResult(List<ItemStack> list) {
        if (list.size() == 2) {
            ItemStack first = list.get(0);
            ItemStack second = list.get(1);
            return CoverRecipe.getResult(first, second);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getResult(ItemStack first, ItemStack second) {
        if (first.func_77973_b().func_206844_a((ITag)Tags.Items.NUGGETS_IRON)) {
            ItemStack stack = new ItemStack((IItemProvider)RSItems.COVER.get());
            CoverItem.setItem(stack, second);
            stack.func_190920_e(6);
            return stack;
        }
        if (second.func_77973_b().func_206844_a((ITag)Tags.Items.NUGGETS_IRON)) {
            ItemStack stack = new ItemStack((IItemProvider)RSItems.COVER.get());
            CoverItem.setItem(stack, first);
            stack.func_190920_e(6);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ArrayList list = Lists.newArrayList();
        int ingots = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            list.add(itemstack);
            if (itemstack.func_77973_b().func_206844_a((ITag)Tags.Items.NUGGETS_IRON)) {
                ++ingots;
                continue;
            }
            if (CoverRecipe.stackMatches(itemstack)) continue;
            return false;
        }
        return CoverRecipe.matches(list) && ingots == 1;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ArrayList list = Lists.newArrayList();
        int ingots = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            list.add(itemstack);
            if (itemstack.func_77973_b().func_206844_a((ITag)Tags.Items.NUGGETS_IRON)) {
                ++ingots;
                continue;
            }
            if (CoverRecipe.stackMatches(itemstack)) continue;
            return ItemStack.field_190927_a;
        }
        if (ingots > 1) {
            return ItemStack.field_190927_a;
        }
        return CoverRecipe.getResult(list);
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

