/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.tracker;

import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.tracker.IStorageTracker;
import com.refinedmods.refinedstorage.api.storage.tracker.IStorageTrackerManager;
import com.refinedmods.refinedstorage.apiimpl.storage.tracker.FluidStorageTracker;
import com.refinedmods.refinedstorage.apiimpl.storage.tracker.ItemStorageTracker;
import com.refinedmods.refinedstorage.apiimpl.util.RSWorldSavedData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class StorageTrackerManager
extends RSWorldSavedData
implements IStorageTrackerManager {
    public static final String NAME = "refinedstorage_tracker";
    private static final String NBT_TRACKERS = "Tracker";
    private static final String NBT_TRACKER_ID = "Id";
    private static final String NBT_TRACKER_DATA = "Data";
    private static final String NBT_TRACKER_TYPE = "Type";
    private final Map<UUID, IStorageTracker<?>> trackers = new HashMap();

    public StorageTrackerManager(String name) {
        super(name);
    }

    @Override
    public void markForSaving() {
        this.func_76185_a();
    }

    @Override
    public IStorageTracker<?> getOrCreate(UUID uuid, StorageType type) {
        IStorageTracker<ItemStack> tracker = this.trackers.get(uuid);
        if (tracker == null) {
            if (type == StorageType.ITEM) {
                tracker = new ItemStorageTracker(this::markForSaving);
            } else if (type == StorageType.FLUID) {
                tracker = new FluidStorageTracker(this::markForSaving);
            }
            this.trackers.put(uuid, tracker);
        }
        return tracker;
    }

    @Override
    public void remove(UUID id) {
        this.trackers.remove(id);
    }

    @Override
    public void func_76184_a(CompoundNBT nbt) {
        if (nbt.func_74764_b(NBT_TRACKERS)) {
            ListNBT trackerTags = nbt.func_150295_c(NBT_TRACKERS, 10);
            for (int i = 0; i < trackerTags.size(); ++i) {
                CompoundNBT trackerTag = trackerTags.func_150305_b(i);
                UUID id = trackerTag.func_186857_a(NBT_TRACKER_ID);
                ListNBT data = trackerTag.func_150295_c(NBT_TRACKER_DATA, 10);
                StorageType type = StorageType.values()[trackerTag.func_74762_e(NBT_TRACKER_TYPE)];
                IStorageTracker<?> tracker = this.getOrCreate(id, type);
                tracker.readFromNbt(data);
            }
        }
    }

    @Override
    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT trackerListTag = new ListNBT();
        for (Map.Entry<UUID, IStorageTracker<?>> entry : this.trackers.entrySet()) {
            CompoundNBT trackerTag = new CompoundNBT();
            trackerTag.func_186854_a(NBT_TRACKER_ID, entry.getKey());
            trackerTag.func_218657_a(NBT_TRACKER_DATA, (INBT)entry.getValue().serializeNbt());
            trackerTag.func_74768_a(NBT_TRACKER_TYPE, entry.getValue() instanceof ItemStorageTracker ? StorageType.ITEM.ordinal() : StorageType.FLUID.ordinal());
            trackerListTag.add((Object)trackerTag);
        }
        compound.func_218657_a(NBT_TRACKERS, (INBT)trackerListTag);
        return compound;
    }
}

