/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.cache.listener;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.util.StackListResult;
import com.refinedmods.refinedstorage.network.grid.PortableGridFluidDeltaMessage;
import com.refinedmods.refinedstorage.network.grid.PortableGridFluidUpdateMessage;
import com.refinedmods.refinedstorage.tile.grid.portable.IPortableGrid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fluids.FluidStack;

public class PortableFluidGridStorageCacheListener
implements IStorageCacheListener<FluidStack> {
    private final IPortableGrid portableGrid;
    private final ServerPlayerEntity player;

    public PortableFluidGridStorageCacheListener(IPortableGrid portableGrid, ServerPlayerEntity player) {
        this.portableGrid = portableGrid;
        this.player = player;
    }

    @Override
    public void onAttached() {
        RS.NETWORK_HANDLER.sendTo(this.player, new PortableGridFluidUpdateMessage(this.portableGrid));
    }

    @Override
    public void onInvalidated() {
    }

    @Override
    public void onChanged(StackListResult<FluidStack> delta) {
        ArrayList<StackListResult<FluidStack>> deltas = new ArrayList<StackListResult<FluidStack>>();
        deltas.add(delta);
        this.onChangedBulk((List<StackListResult<FluidStack>>)deltas);
    }

    @Override
    public void onChangedBulk(List<StackListResult<FluidStack>> storageCacheDeltas) {
        RS.NETWORK_HANDLER.sendTo(this.player, new PortableGridFluidDeltaMessage(this.portableGrid, storageCacheDeltas));
    }
}

