/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.measures;

import java.util.UUID;
import mod.chiselsandbits.api.measuring.IMeasurement;
import mod.chiselsandbits.api.measuring.MeasuringMode;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import org.jetbrains.annotations.NotNull;

public class Measurement
implements IMeasurement,
IPacketBufferSerializable {
    private UUID owner;
    private Vector3d from;
    private Vector3d to;
    private MeasuringMode mode;
    private ResourceLocation worldKey;

    public Measurement() {
    }

    public Measurement(UUID owner, Vector3d from, Vector3d to, MeasuringMode mode, ResourceLocation worldKey) {
        this.owner = owner;
        this.from = mode.getType().adaptStartPosition(from, to);
        this.to = mode.getType().adaptEndPosition(from, to);
        this.mode = mode;
        this.worldKey = worldKey;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public Vector3d getFrom() {
        return this.from;
    }

    @Override
    public Vector3d getTo() {
        return this.to;
    }

    @Override
    public MeasuringMode getMode() {
        return this.mode;
    }

    @Override
    public ResourceLocation getWorldKey() {
        return this.worldKey;
    }

    @Override
    public void serializeInto(@NotNull PacketBuffer packetBuffer) {
        packetBuffer.func_179252_a(this.getOwner());
        packetBuffer.writeDouble(this.getFrom().func_82615_a());
        packetBuffer.writeDouble(this.getFrom().func_82617_b());
        packetBuffer.writeDouble(this.getFrom().func_82616_c());
        packetBuffer.writeDouble(this.getTo().func_82615_a());
        packetBuffer.writeDouble(this.getTo().func_82617_b());
        packetBuffer.writeDouble(this.getTo().func_82616_c());
        packetBuffer.func_150787_b(this.mode.ordinal());
        packetBuffer.func_211400_a(this.getWorldKey().toString(), 0x1FFFFFFF);
    }

    @Override
    public void deserializeFrom(@NotNull PacketBuffer packetBuffer) {
        this.owner = packetBuffer.func_179253_g();
        this.from = new Vector3d(packetBuffer.readDouble(), packetBuffer.readDouble(), packetBuffer.readDouble());
        this.to = new Vector3d(packetBuffer.readDouble(), packetBuffer.readDouble(), packetBuffer.readDouble());
        this.mode = MeasuringMode.values()[packetBuffer.func_150792_a()];
        this.worldKey = new ResourceLocation(packetBuffer.func_150789_c(0x1FFFFFFF));
    }
}

