/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.container;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import mod.chiselsandbits.recipe.modificationtable.ModificationTableRecipe;
import mod.chiselsandbits.registrars.ModBlocks;
import mod.chiselsandbits.registrars.ModContainerTypes;
import mod.chiselsandbits.registrars.ModRecipeTypes;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ModificationTableContainer
extends Container {
    private final IWorldPosCallable worldPosCallable;
    private final IntReferenceHolder selectedRecipe = IntReferenceHolder.func_221492_a();
    private final World world;
    private List<ModificationTableRecipe> recipes = Lists.newArrayList();
    private ItemStack inputItemStack = ItemStack.field_190927_a;
    private long lastOnTake;
    final Slot inputInventorySlot;
    final Slot outputInventorySlot;
    private Runnable inventoryUpdateListener = () -> {};
    public final IInventory inputInventory = new Inventory(1){

        public void func_70296_d() {
            super.func_70296_d();
            ModificationTableContainer.this.func_75130_a((IInventory)this);
            ModificationTableContainer.this.inventoryUpdateListener.run();
        }
    };
    private final CraftResultInventory inventory = new CraftResultInventory();

    public ModificationTableContainer(int windowIdIn, PlayerInventory playerInventoryIn) {
        this(windowIdIn, playerInventoryIn, IWorldPosCallable.field_221489_a);
    }

    public ModificationTableContainer(int windowIdIn, PlayerInventory playerInventoryIn, final IWorldPosCallable worldPosCallableIn) {
        super((ContainerType)ModContainerTypes.MODIFICATION_TABLE.get(), windowIdIn);
        this.worldPosCallable = worldPosCallableIn;
        this.world = playerInventoryIn.field_70458_d.field_70170_p;
        this.inputInventorySlot = this.func_75146_a(new Slot(this.inputInventory, 0, 20, 33));
        this.outputInventorySlot = this.func_75146_a(new Slot((IInventory)this.inventory, 1, 143, 33){

            public boolean func_75214_a(@NotNull ItemStack stack) {
                return false;
            }

            @NotNull
            public ItemStack func_190901_a(@NotNull PlayerEntity thePlayer, @NotNull ItemStack stack) {
                stack.func_77980_a(thePlayer.field_70170_p, thePlayer, stack.func_190916_E());
                ModificationTableContainer.this.inventory.func_201560_d(thePlayer);
                ItemStack itemstack = ModificationTableContainer.this.inputInventorySlot.func_75209_a(1);
                if (!itemstack.func_190926_b()) {
                    ModificationTableContainer.this.updateRecipeResultSlot();
                }
                worldPosCallableIn.func_221486_a((p_216954_1_, p_216954_2_) -> {
                    long l = p_216954_1_.func_82737_E();
                    if (ModificationTableContainer.this.lastOnTake != l) {
                        p_216954_1_.func_184133_a(null, p_216954_2_, SoundEvents.field_219719_ml, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        ModificationTableContainer.this.lastOnTake = l;
                    }
                });
                return super.func_190901_a(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 115 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventoryIn, k, 8 + k * 18, 173));
        }
        this.func_216958_a(this.selectedRecipe);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSelectedRecipe() {
        return this.selectedRecipe.func_221495_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ModificationTableRecipe> getRecipeList() {
        return this.recipes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRecipeListSize() {
        return this.recipes.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasItemsInInputSlot() {
        return this.inputInventorySlot.func_75216_d() && !this.recipes.isEmpty();
    }

    public boolean func_75145_c(@NotNull PlayerEntity playerIn) {
        return ModificationTableContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)((Block)ModBlocks.MODIFICATION_TABLE.get()));
    }

    public boolean func_75140_a(@NotNull PlayerEntity playerIn, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipe.func_221494_a(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int p_241818_1_) {
        return p_241818_1_ >= 0 && p_241818_1_ < this.recipes.size();
    }

    public void func_75130_a(@NotNull IInventory inventoryIn) {
        ItemStack itemstack = this.inputInventorySlot.func_75211_c();
        if (itemstack.func_77973_b() != this.inputItemStack.func_77973_b()) {
            this.inputItemStack = itemstack.func_77946_l();
            this.updateAvailableRecipes(inventoryIn, itemstack);
        }
    }

    private void updateAvailableRecipes(IInventory inventoryIn, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.func_221494_a(-1);
        this.outputInventorySlot.func_75215_d(ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            this.recipes = this.world.func_199532_z().func_215370_b(ModRecipeTypes.MODIFICATION_TABLE, inventoryIn, this.world);
            this.recipes.sort(Comparator.comparing(modificationTableRecipe -> Objects.requireNonNull(modificationTableRecipe.getOperation().getRegistryName()).toString()));
        }
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipe.func_221495_b())) {
            ModificationTableRecipe modificationTableRecipe = this.recipes.get(this.selectedRecipe.func_221495_b());
            this.inventory.func_193056_a((IRecipe)modificationTableRecipe);
            this.outputInventorySlot.func_75215_d(modificationTableRecipe.func_77572_b(this.inputInventory));
        } else {
            this.outputInventorySlot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    @NotNull
    public ContainerType<?> func_216957_a() {
        return (ContainerType)ModContainerTypes.MODIFICATION_TABLE.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean func_94530_a(@NotNull ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.inventory && super.func_94530_a(stack, slotIn);
    }

    @NotNull
    public ItemStack func_82846_b(@NotNull PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            Item item = itemstack1.func_77973_b();
            itemstack = itemstack1.func_77946_l();
            if (index == 1) {
                item.func_77622_d(itemstack1, playerIn.field_70170_p, playerIn);
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index == 0 ? !this.func_75135_a(itemstack1, 2, 38, false) : (this.world.func_199532_z().func_215371_a(ModRecipeTypes.MODIFICATION_TABLE, (IInventory)new Inventory(new ItemStack[]{itemstack1}), this.world).isPresent() ? !this.func_75135_a(itemstack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.func_75135_a(itemstack1, 29, 38, false) : index >= 29 && index < 38 && !this.func_75135_a(itemstack1, 2, 29, false)))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
            this.func_75142_b();
        }
        return itemstack;
    }

    public void func_75134_a(@NotNull PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.inventory.func_70304_b(1);
        this.worldPosCallable.func_221486_a((p_217079_2_, p_217079_3_) -> this.func_193327_a(playerIn, playerIn.field_70170_p, this.inputInventory));
    }
}

