/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.LightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleGeneratedModel
implements IBakedModel {
    private final List<BakedQuad>[] face = new List[6];
    private final TextureAtlasSprite texture;

    public SimpleGeneratedModel(TextureAtlasSprite texture) {
        this.face[0] = new ArrayList<BakedQuad>();
        this.face[1] = new ArrayList<BakedQuad>();
        this.face[2] = new ArrayList<BakedQuad>();
        this.face[3] = new ArrayList<BakedQuad>();
        this.face[4] = new ArrayList<BakedQuad>();
        this.face[5] = new ArrayList<BakedQuad>();
        this.texture = texture;
        float[] afloat = new float[]{0.0f, 0.0f, 16.0f, 16.0f};
        BlockFaceUV uv = new BlockFaceUV(afloat, 0);
        FaceBakery faceBakery = new FaceBakery();
        Vector3f to = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f from = new Vector3f(16.0f, 16.0f, 16.0f);
        ModelRotation mr = ModelRotation.X0_Y0;
        for (Direction side : Direction.values()) {
            Vector3f fromB;
            Vector3f toB;
            BlockPartFace bpf = new BlockPartFace(side, 1, "", uv);
            switch (side) {
                case UP: {
                    toB = new Vector3f(to.func_195899_a(), from.func_195900_b(), to.func_195902_c());
                    fromB = new Vector3f(from.func_195899_a(), from.func_195900_b(), from.func_195902_c());
                    break;
                }
                case EAST: {
                    toB = new Vector3f(from.func_195899_a(), to.func_195900_b(), to.func_195902_c());
                    fromB = new Vector3f(from.func_195899_a(), from.func_195900_b(), from.func_195902_c());
                    break;
                }
                case NORTH: {
                    toB = new Vector3f(to.func_195899_a(), to.func_195900_b(), to.func_195902_c());
                    fromB = new Vector3f(from.func_195899_a(), from.func_195900_b(), to.func_195902_c());
                    break;
                }
                case SOUTH: {
                    toB = new Vector3f(to.func_195899_a(), to.func_195900_b(), from.func_195902_c());
                    fromB = new Vector3f(from.func_195899_a(), from.func_195900_b(), from.func_195902_c());
                    break;
                }
                case DOWN: {
                    toB = new Vector3f(to.func_195899_a(), to.func_195900_b(), to.func_195902_c());
                    fromB = new Vector3f(from.func_195899_a(), to.func_195900_b(), from.func_195902_c());
                    break;
                }
                case WEST: {
                    toB = new Vector3f(to.func_195899_a(), to.func_195900_b(), to.func_195902_c());
                    fromB = new Vector3f(to.func_195899_a(), from.func_195900_b(), from.func_195902_c());
                    break;
                }
                default: {
                    throw new NullPointerException();
                }
            }
            BakedQuad g = faceBakery.func_228824_a_(toB, fromB, bpf, texture, side, (IModelTransform)mr, null, false, new ResourceLocation("chiselsandbits", "simple"));
            this.face[side.ordinal()].add(this.finishFace(g, side));
        }
    }

    private BakedQuad finishFace(BakedQuad g, Direction myFace) {
        int[] vertData = g.func_178209_a();
        int wrapAt = vertData.length / 4;
        BakedQuadBuilder b = new BakedQuadBuilder(g.field_187509_d);
        b.setQuadOrientation(myFace);
        b.setQuadTint(1);
        for (int vertNum = 0; vertNum < 4; ++vertNum) {
            block7: for (int elementIndex = 0; elementIndex < DefaultVertexFormats.field_176600_a.func_227894_c_().size(); ++elementIndex) {
                VertexFormatElement element = (VertexFormatElement)DefaultVertexFormats.field_176600_a.func_227894_c_().get(elementIndex);
                switch (element.func_177375_c()) {
                    case POSITION: {
                        b.put(elementIndex, new float[]{Float.intBitsToFloat(vertData[wrapAt * vertNum]), Float.intBitsToFloat(vertData[1 + wrapAt * vertNum]), Float.intBitsToFloat(vertData[2 + wrapAt * vertNum])});
                        continue block7;
                    }
                    case COLOR: {
                        float light = LightUtil.diffuseLight((Direction)myFace);
                        b.put(elementIndex, new float[]{light, light, light, 1.0f});
                        continue block7;
                    }
                    case NORMAL: {
                        b.put(elementIndex, new float[]{myFace.func_82601_c(), myFace.func_96559_d(), myFace.func_82599_e()});
                        continue block7;
                    }
                    case UV: {
                        if (element.func_177369_e() == 1) {
                            b.put(elementIndex, new float[]{0.0f, 0.0f});
                            continue block7;
                        }
                        float u = Float.intBitsToFloat(vertData[4 + wrapAt * vertNum]);
                        float v = Float.intBitsToFloat(vertData[5 + wrapAt * vertNum]);
                        b.put(elementIndex, new float[]{u, v});
                        continue block7;
                    }
                    default: {
                        b.put(elementIndex, new float[0]);
                    }
                }
            }
        }
        return b.build();
    }

    public List<BakedQuad>[] getFace() {
        return this.face;
    }

    @NotNull
    public List<BakedQuad> func_200117_a(BlockState state, Direction side, @NotNull Random rand) {
        if (side == null) {
            return Collections.emptyList();
        }
        return this.face[side.ordinal()];
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData extraData) {
        if (side == null) {
            return Collections.emptyList();
        }
        return this.face[side.ordinal()];
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_230044_c_() {
        return false;
    }

    @NotNull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    @NotNull
    public TextureAtlasSprite func_177554_e() {
        return this.texture;
    }

    public boolean func_188618_c() {
        return false;
    }

    @NotNull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

