/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mod.chiselsandbits.api.block.bitbag.IBitBagAcceptingBlock;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.block.entities.BitStorageBlockEntity;
import mod.chiselsandbits.item.BitBagItem;
import mod.chiselsandbits.registrars.ModItems;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitStorageBlock
extends Block
implements ITileEntityProvider,
IBitBagAcceptingBlock {
    public static final Property<Direction> FACING = HorizontalBlock.field_185512_D;

    public BitStorageBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)context.func_195992_f());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    @Nullable
    public TileEntity func_196283_a_(@NotNull IBlockReader worldIn) {
        return new BitStorageBlockEntity();
    }

    @NotNull
    public ActionResultType func_225533_a_(@NotNull BlockState state, World worldIn, @NotNull BlockPos pos, @NotNull PlayerEntity player, @NotNull Hand handIn, @NotNull BlockRayTraceResult hit) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof BitStorageBlockEntity)) {
            return ActionResultType.FAIL;
        }
        BitStorageBlockEntity tank = (BitStorageBlockEntity)tileEntity;
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current.func_77973_b() instanceof BitBagItem) {
            return ActionResultType.PASS;
        }
        if (!current.func_190926_b()) {
            if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (IFluidHandler)tank)) {
                return ActionResultType.SUCCESS;
            }
            if (tank.addHeldBits(current, player)) {
                return ActionResultType.SUCCESS;
            }
        } else if (tank.addAllPossibleBits(player)) {
            return ActionResultType.SUCCESS;
        }
        if (tank.extractBits(player, hit.func_216347_e().field_72450_a, hit.func_216347_e().field_72448_b, hit.func_216347_e().field_72449_c, pos)) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(@NotNull BlockState state, @NotNull IBlockReader worldIn, @NotNull BlockPos pos) {
        return 1.0f;
    }

    public boolean func_200123_i(@NotNull BlockState state, @NotNull IBlockReader reader, @NotNull BlockPos pos) {
        return true;
    }

    @NotNull
    public List<ItemStack> func_220076_a(@NotNull BlockState state, LootContext.Builder builder) {
        if (builder.func_216019_b(LootParameters.field_216288_h) == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new ItemStack[]{this.getTankDrop((BitStorageBlockEntity)((Object)builder.func_216019_b(LootParameters.field_216288_h)))});
    }

    public ItemStack getTankDrop(BitStorageBlockEntity bitTank) {
        ItemStack tankStack = new ItemStack((IItemProvider)ModItems.BIT_STORAGE.get());
        tankStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(s -> s.fill(bitTank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(t -> t.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE)).orElse(FluidStack.EMPTY), IFluidHandler.FluidAction.EXECUTE));
        return tankStack;
    }

    @Override
    public void onBitBagInteraction(ItemStack bitBagStack, PlayerEntity player, BlockRayTraceResult blockRayTraceResult) {
        Optional<BlockState> toExtractCandidate;
        TileEntity tileEntity = player.field_70170_p.func_175625_s(blockRayTraceResult.func_216350_a());
        if (!(tileEntity instanceof BitStorageBlockEntity)) {
            return;
        }
        BitStorageBlockEntity tank = (BitStorageBlockEntity)tileEntity;
        IBitInventory bitInventory = IBitInventoryManager.getInstance().create(bitBagStack);
        BlockState containedState = tank.getState();
        Fluid containedFluid = tank.getMyFluid();
        if (player.func_213453_ef() && (containedFluid != null || containedState != null)) {
            BlockState toInsertState = containedFluid != null ? containedFluid.func_207188_f().func_206883_i() : containedState;
            int maxAmountToInsert = bitInventory.getMaxInsertAmount(toInsertState);
            int bitCountToInsert = Math.min(tank.getBits(), maxAmountToInsert);
            tank.extractBits(0, bitCountToInsert, false);
            bitInventory.insert(toInsertState, bitCountToInsert);
        } else if ((containedFluid != null || containedState != null) && tank.getBits() != 0) {
            BlockState toExtractState = containedFluid != null ? containedFluid.func_207188_f().func_206883_i() : containedState;
            int maxAmountToInsert = StateEntrySize.current().getBitsPerBlock() - tank.getBits();
            int bitCountToInsert = Math.min(bitInventory.getMaxExtractAmount(toExtractState), maxAmountToInsert);
            tank.insertBits(bitCountToInsert, toExtractState, false);
            bitInventory.extract(toExtractState, bitCountToInsert);
        } else if (!player.func_213453_ef() && (toExtractCandidate = bitInventory.getContainedStates().entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey)).isPresent()) {
            BlockState toExtractState = toExtractCandidate.get();
            int maxAmountToInsert = StateEntrySize.current().getBitsPerBlock();
            int bitCountToInsert = Math.min(bitInventory.getMaxExtractAmount(toExtractState), maxAmountToInsert);
            tank.insertBits(bitCountToInsert, toExtractState, false);
            bitInventory.extract(toExtractState, bitCountToInsert);
        }
    }
}

