/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.aabb;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.aabb.AABBCompressor;
import mod.chiselsandbits.api.IChiselsAndBitsAPI;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.ForgeConfigSpec;

public class AABBManager {
    private static final AABBManager INSTANCE = new AABBManager();
    private final SimpleMaxSizedCache<Key, Collection<AxisAlignedBB>> cache = new SimpleMaxSizedCache(() -> ((ForgeConfigSpec.LongValue)IChiselsAndBitsAPI.getInstance().getConfiguration().getCommon().collisionBoxCacheSize).get());

    public static AABBManager getInstance() {
        return INSTANCE;
    }

    private AABBManager() {
    }

    public Collection<AxisAlignedBB> get(IAreaAccessor accessor, Function<IAreaAccessor, Predicate<IStateEntryInfo>> selectablePredicateBuilder) {
        Predicate<IStateEntryInfo> selectablePredicate = selectablePredicateBuilder.apply(accessor);
        Key cacheKey = new Key(accessor.createNewShapeIdentifier(), selectablePredicate);
        return this.cache.get(cacheKey, () -> AABBCompressor.compressStates(accessor, selectablePredicate));
    }

    public void clearCache() {
        this.cache.clear();
    }

    private static final class Key {
        private final IAreaShapeIdentifier identifier;
        private final Predicate<IStateEntryInfo> predicate;

        private Key(IAreaShapeIdentifier identifier, Predicate<IStateEntryInfo> predicate) {
            this.identifier = identifier;
            this.predicate = predicate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.identifier, key.identifier) && Objects.equals(this.predicate, key.predicate);
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.predicate);
        }
    }
}

