/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.util.ComparableItemStack;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.internal.BaseMachineRecipe;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CrafterRecipe
extends BaseMachineRecipe {
    protected final List<Ingredient> ingredients;
    protected final Set<ComparableItemStack> validItems = new ObjectOpenHashSet();
    protected Set<Fluid> validFluids = new ObjectOpenHashSet();
    public static final List<Float> CHANCE = Collections.singletonList(Float.valueOf(1.0f));
    public static final Pair<List<Integer>, List<Integer>> EMPTY_PAIR = Pair.of(Collections.emptyList(), Collections.emptyList());

    public CrafterRecipe(int energy, IRecipe<?> recipe) {
        super(energy, 0.0f);
        this.ingredients = recipe.func_192400_c();
        for (Ingredient ing : this.ingredients) {
            for (ItemStack stack : ing.func_193365_a()) {
                this.validItems.add(AbstractManager.convert(stack));
                FluidUtil.getFluidContained((ItemStack)stack).ifPresent(fluidStack -> {
                    if (!fluidStack.isEmpty()) {
                        this.validFluids.add(fluidStack.getFluid());
                    }
                });
            }
        }
        this.outputItems.add(recipe.func_77571_b());
        this.outputItemChances.add(Float.valueOf(-1.0f));
    }

    public boolean validItem(ItemStack item) {
        return this.validItems.contains(AbstractManager.convert(item));
    }

    public boolean validFluid(FluidStack fluid) {
        return this.validFluids.contains(fluid.getFluid());
    }

    @Override
    public List<Float> getOutputItemChances(IMachineInventory inventory) {
        return CHANCE;
    }

    @Override
    public Pair<List<Integer>, List<Integer>> getInputItemAndFluidCounts(IMachineInventory inventory) {
        if (this.ingredients.isEmpty()) {
            return EMPTY_PAIR;
        }
        int found = 0;
        int storedFluidAmount = inventory.inputTanks().get(0).getAmount();
        int[] retItems = new int[inventory.inputSlots().size()];
        boolean foundItem = false;
        int retFluid = 0;
        if (storedFluidAmount > 0) {
            FluidStack storedFluid = inventory.inputTanks().get(0).getFluidStack();
            block0: for (Ingredient ing : this.ingredients) {
                if (ing.func_203189_d()) {
                    ++found;
                    continue;
                }
                for (ItemStack stack : ing.func_193365_a()) {
                    FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
                    if (FluidHelper.fluidsEqual((FluidStack)storedFluid, (FluidStack)fluid) && storedFluidAmount - retFluid >= fluid.getAmount()) {
                        retFluid += fluid.getAmount();
                        ++found;
                        continue block0;
                    }
                    int curFound = found;
                    for (int j = 0; j < retItems.length; ++j) {
                        ItemStack inSlot = inventory.inputSlots().get(j).getItemStack();
                        if (inSlot.func_190916_E() <= retItems[j] || !ItemHelper.itemsEqual((ItemStack)stack, (ItemStack)inSlot)) continue;
                        int n = j;
                        retItems[n] = retItems[n] + 1;
                        ++found;
                        foundItem = true;
                        break;
                    }
                    if (found > curFound) continue block0;
                }
            }
        } else {
            block3: for (Ingredient ing : this.ingredients) {
                if (ing.func_203189_d()) {
                    ++found;
                    continue;
                }
                for (ItemStack stack : ing.func_193365_a()) {
                    int curFound = found;
                    for (int j = 0; j < retItems.length; ++j) {
                        ItemStack inSlot = inventory.inputSlots().get(j).getItemStack();
                        if (inSlot.func_190916_E() <= retItems[j] || !ItemHelper.itemsEqual((ItemStack)stack, (ItemStack)inSlot)) continue;
                        int n = j;
                        retItems[n] = retItems[n] + 1;
                        ++found;
                        foundItem = true;
                        break;
                    }
                    if (found > curFound) continue block3;
                }
            }
        }
        if (found < this.ingredients.size()) {
            return EMPTY_PAIR;
        }
        List itemCounts = foundItem ? IntStream.of(retItems).boxed().collect(Collectors.toList()) : Collections.emptyList();
        List fluidCounts = retFluid > 0 ? Collections.singletonList(retFluid) : Collections.emptyList();
        return Pair.of(itemCounts, fluidCounts);
    }
}

