/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.storage;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidHandlerRestrictionWrapper;
import cofh.lib.fluid.FluidStorageAdjustable;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.tileentity.ITilePacketHandler;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.storage.FluidCellContainer;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.CellTileBase;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidCellTile
extends CellTileBase
implements ITickableTileEntity {
    public static final int BASE_CAPACITY = 32000;
    protected FluidStorageCoFH fluidStorage = new FluidStorageAdjustable(32000, fluid -> this.filter.valid(fluid)).setTransferLimits(() -> this.amountInput, () -> this.amountOutput);
    protected LazyOptional<?> inputFluidCap = LazyOptional.empty();
    protected LazyOptional<?> outputFluidCap = LazyOptional.empty();

    public FluidCellTile() {
        super(TCoreReferences.FLUID_CELL_TILE);
        this.amountInput = 1000;
        this.amountOutput = 1000;
        this.tankInv.addTank(this.fluidStorage, StorageGroup.ACCESSIBLE);
        this.transferControl.initControl(false, true);
        this.addAugmentSlots(ThermalConfig.storageAugments);
        this.initHandlers();
    }

    public void func_73660_a() {
        if (this.redstoneControl.getState()) {
            this.transferOut();
            this.transferIn();
        }
        if (Utils.timeCheck((World)this.field_145850_b) || this.fluidStorage.getFluidStack().getFluid() != this.renderFluid.getFluid()) {
            this.updateTrackers(true);
        }
    }

    public int getLightValue() {
        return FluidHelper.luminosity((FluidStack)this.renderFluid);
    }

    protected void transferIn() {
        int i;
        if (!this.transferControl.getTransferIn()) {
            return;
        }
        if (this.amountInput <= 0 || this.fluidStorage.isFull()) {
            return;
        }
        for (i = this.inputTracker; i < 6 && this.fluidStorage.getSpace() > 0; ++i) {
            if (!this.reconfigControl.getSideConfig(i).isInput()) continue;
            this.attemptTransferIn(Direction.func_82600_a((int)i));
        }
        for (i = 0; i < this.inputTracker && this.fluidStorage.getSpace() > 0; ++i) {
            if (!this.reconfigControl.getSideConfig(i).isInput()) continue;
            this.attemptTransferIn(Direction.func_82600_a((int)i));
        }
        ++this.inputTracker;
        this.inputTracker %= 6;
    }

    protected void transferOut() {
        int i;
        if (!this.transferControl.getTransferOut()) {
            return;
        }
        if (this.amountOutput <= 0 || this.fluidStorage.isEmpty()) {
            return;
        }
        for (i = this.outputTracker; i < 6 && this.fluidStorage.getAmount() > 0; ++i) {
            if (!this.reconfigControl.getSideConfig(i).isOutput()) continue;
            this.attemptTransferOut(Direction.func_82600_a((int)i));
        }
        for (i = 0; i < this.outputTracker && this.fluidStorage.getAmount() > 0; ++i) {
            if (!this.reconfigControl.getSideConfig(i).isOutput()) continue;
            this.attemptTransferOut(Direction.func_82600_a((int)i));
        }
        ++this.outputTracker;
        this.outputTracker %= 6;
    }

    protected void attemptTransferIn(Direction side) {
        FluidHelper.extractFromAdjacent((TileEntity)this, (FluidStorageCoFH)this.fluidStorage, (int)Math.min(this.amountInput, this.fluidStorage.getSpace()), (Direction)side);
    }

    protected void attemptTransferOut(Direction side) {
        TileEntity adjTile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (Direction)side);
        if (adjTile != null) {
            Direction opposite = side.func_176734_d();
            int maxTransfer = Math.min(this.amountOutput, this.fluidStorage.getAmount());
            adjTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opposite).ifPresent(e -> this.fluidStorage.modify(-e.fill(new FluidStack(this.fluidStorage.getFluidStack(), maxTransfer), IFluidHandler.FluidAction.EXECUTE)));
        }
    }

    @Override
    protected boolean keepFluids() {
        return true;
    }

    @Override
    public int getMaxInput() {
        return this.fluidStorage.getCapacity() / 4;
    }

    @Override
    public int getMaxOutput() {
        return this.fluidStorage.getCapacity() / 4;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new FluidCellContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.SIDES, (Object)this.reconfigControl().getRawSideConfig()).withInitial(ModelUtils.FACING, (Object)this.reconfigControl.getFacing()).withInitial(ModelUtils.FLUID, (Object)this.renderFluid).withInitial(ModelUtils.LEVEL, (Object)this.levelTracker).build();
    }

    @Override
    protected void updateTrackers(boolean send) {
        int curScale;
        this.prevLight = this.getLightValue();
        this.renderFluid = this.fluidStorage.getFluidStack();
        int n = curScale = this.fluidStorage.getAmount() > 0 ? 1 + (int)(this.fluidStorage.getRatio() * 14.0) : 0;
        if (curScale != this.compareTracker) {
            this.compareTracker = curScale;
            if (send) {
                this.func_70296_d();
            }
        }
        if (this.fluidStorage.isCreative()) {
            curScale = this.fluidStorage.isEmpty() ? 10 : 9;
        } else {
            int n2 = curScale = this.fluidStorage.getAmount() > 0 ? 1 + Math.min((int)(this.fluidStorage.getRatio() * 8.0), 7) : 0;
        }
        if (this.levelTracker != curScale) {
            this.levelTracker = curScale;
            if (send) {
                TileStatePacket.sendToClient((ITilePacketHandler)this);
            }
        }
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && ThermalAugmentRules.FLUID_STORAGE_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void updateHandlers() {
        LazyOptional prevFluidCap = this.fluidCap;
        LazyOptional<?> prevFluidInputCap = this.inputFluidCap;
        LazyOptional<?> prevFluidOutputCap = this.outputFluidCap;
        FluidHandlerRestrictionWrapper inputHandler = new FluidHandlerRestrictionWrapper((IFluidHandler)this.fluidStorage, true, false);
        FluidHandlerRestrictionWrapper outputHandler = new FluidHandlerRestrictionWrapper((IFluidHandler)this.fluidStorage, false, true);
        this.fluidCap = LazyOptional.of(() -> this.fluidStorage);
        this.inputFluidCap = LazyOptional.of(() -> FluidCellTile.lambda$updateHandlers$6((IFluidHandler)inputHandler));
        this.outputFluidCap = LazyOptional.of(() -> FluidCellTile.lambda$updateHandlers$7((IFluidHandler)outputHandler));
        prevFluidCap.invalidate();
        prevFluidInputCap.invalidate();
        prevFluidOutputCap.invalidate();
    }

    @Override
    protected <T> LazyOptional<T> getFluidHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return super.getFluidHandlerCapability(side);
        }
        switch (this.reconfigControl.getSideConfig(side)) {
            case SIDE_NONE: {
                return LazyOptional.empty();
            }
            case SIDE_INPUT: {
                return this.inputFluidCap.cast();
            }
            case SIDE_OUTPUT: {
                return this.outputFluidCap.cast();
            }
        }
        return super.getFluidHandlerCapability(side);
    }

    private static /* synthetic */ IFluidHandler lambda$updateHandlers$7(IFluidHandler outputHandler) {
        return outputHandler;
    }

    private static /* synthetic */ IFluidHandler lambda$updateHandlers$6(IFluidHandler inputHandler) {
        return inputHandler;
    }
}

