/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.event;

import cofh.core.client.CoreRenderType;
import cofh.core.util.ProxyClient;
import cofh.lib.tileentity.IAreaEffectTile;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.item.WrenchItem;
import cofh.thermal.lib.common.ThermalAugmentRules;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="thermal")
public class TCoreClientEvents {
    private TCoreClientEvents() {
    }

    @SubscribeEvent
    public static void handleItemTooltipEvent(ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        if (tooltip.isEmpty()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (AugmentDataHelper.hasAugmentData((ItemStack)stack)) {
            CompoundNBT augmentData = AugmentDataHelper.getAugmentData((ItemStack)stack);
            if (augmentData == null || augmentData.isEmpty()) {
                return;
            }
            String type = augmentData.func_74779_i("Type");
            if (!type.isEmpty()) {
                IFormattableTextComponent typeText = StringHelper.getTextComponent((String)("info.thermal.augment.type." + type)).func_240699_a_(TextFormatting.WHITE);
                tooltip.add(StringHelper.getTextComponent((String)"info.cofh.type").func_240699_a_(TextFormatting.YELLOW).func_240702_b_(": ").func_230529_a_((ITextComponent)typeText));
            }
            for (String mod : augmentData.func_150296_c()) {
                if (mod.equals("Type") || !StringHelper.canLocalize((String)("info.thermal.augment.attr." + mod))) continue;
                float value = augmentData.func_74760_g(mod);
                boolean bad = ThermalAugmentRules.isAdditive(mod) && value < 0.0f || ThermalAugmentRules.isAdditive(mod) && value > 0.0f && ThermalAugmentRules.isInverse(mod) || ThermalAugmentRules.isMultiplicative(mod) && (ThermalAugmentRules.isInverse(mod) ? (double)value > 1.0 : (double)value < 1.0);
                IFormattableTextComponent modText = new StringTextComponent("" + (ThermalAugmentRules.isAdditive(mod) && value > 0.0f ? "+" : "") + (ThermalAugmentRules.isInteger(mod) ? StringHelper.DF0.format(value) : (ThermalAugmentRules.isMultiplicative(mod) ? StringHelper.DF2.format(value) + "x" : StringHelper.DF0.format(value * 100.0f) + "%"))).func_240699_a_(bad ? TextFormatting.RED : TextFormatting.GREEN);
                if (ThermalAugmentRules.isMaximized(mod)) {
                    modText.func_240699_a_(TextFormatting.UNDERLINE);
                }
                tooltip.add(StringHelper.getTextComponent((String)("info.thermal.augment.attr." + mod)).func_240702_b_(": ").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)modText));
            }
        }
    }

    @SubscribeEvent
    public static void handleRenderWorldLast(RenderWorldLastEvent event) {
        Item heldItem;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (heldItem = player.func_184614_ca().func_77973_b()) instanceof WrenchItem && ((WrenchItem)heldItem).getMode(player.func_184614_ca()) > 0) {
            TCoreClientEvents.renderOperationalAreas(player, event.getMatrixStack());
        }
    }

    private static boolean playerWithinDistance(BlockPos pos, PlayerEntity player, double distanceSq) {
        return pos.func_218138_a((IPosition)player.func_213303_ch(), true) <= distanceSq;
    }

    private static void line(IVertexBuilder builder, Matrix4f positionMatrix, BlockPos pos, float dx1, float dy1, float dz1, float dx2, float dy2, float dz2, int r, int g, int b, int a) {
        builder.func_227888_a_(positionMatrix, (float)pos.func_177958_n() + dx1, (float)pos.func_177956_o() + dy1, (float)pos.func_177952_p() + dz1).func_225586_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(positionMatrix, (float)pos.func_177958_n() + dx2, (float)pos.func_177956_o() + dy2, (float)pos.func_177952_p() + dz2).func_225586_a_(r, g, b, a).func_181675_d();
    }

    private static void box(IVertexBuilder builder, Matrix4f positionMatrix, BlockPos pos, AxisAlignedBB area, int color) {
        float lenX = (float)(area.field_72336_d - area.field_72340_a);
        float lenY = (float)(area.field_72337_e - area.field_72338_b);
        float lenZ = (float)(area.field_72334_f - area.field_72339_c);
        int a = 192;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, 0.0f, 0.0f, lenX, 0.0f, 0.0f, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, lenY, 0.0f, lenX, lenY, 0.0f, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, 0.0f, lenZ, lenX, 0.0f, lenZ, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, lenY, lenZ, lenX, lenY, lenZ, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, lenZ, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, lenX, 0.0f, 0.0f, lenX, 0.0f, lenZ, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, lenY, 0.0f, 0.0f, lenY, lenZ, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, lenX, lenY, 0.0f, lenX, lenY, lenZ, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, 0.0f, 0.0f, 0.0f, lenY, 0.0f, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, lenX, 0.0f, 0.0f, lenX, lenY, 0.0f, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, 0.0f, lenZ, 0.0f, lenY, lenZ, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, lenX, 0.0f, lenZ, lenX, lenY, lenZ, r, g, b, a);
    }

    private static void renderOperationalAreas(ClientPlayerEntity player, MatrixStack matrixStack) {
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(CoreRenderType.OVERLAY_LINES);
        matrixStack.func_227860_a_();
        Vector3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        Matrix4f positionMatrix = matrixStack.func_227866_c_().func_227870_a_();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (IAreaEffectTile tile : ProxyClient.getAreaEffectTiles()) {
            if (!tile.canPlayerAccess((PlayerEntity)player) || !TCoreClientEvents.playerWithinDistance(tile.pos(), (PlayerEntity)player, 1024.0)) continue;
            AxisAlignedBB area = tile.getArea();
            pos.func_189532_c(area.field_72340_a, area.field_72338_b, area.field_72339_c);
            TCoreClientEvents.box(builder, positionMatrix, (BlockPos)pos, area, tile.getColor());
        }
        matrixStack.func_227865_b_();
        RenderSystem.disableDepthTest();
        buffer.func_228462_a_(CoreRenderType.OVERLAY_LINES);
    }
}

