/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.crt.machine;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.machine.InsolatorCatalyst;
import cofh.thermal.lib.compat.crt.actions.ActionRemoveThermalCatalystByOutput;
import cofh.thermal.lib.compat.crt.base.CRTCatalyst;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.thermal.InsolatorCatalyst")
@IRecipeHandler.For(value=InsolatorCatalyst.class)
public class CRTInsolatorCatalystManager
implements IRecipeManager,
IRecipeHandler<InsolatorCatalyst> {
    @ZenCodeType.Method
    public void addCatalyst(String name, IIngredientWithAmount ingredient, float primaryMod, float secondaryMod, float energyMod, float minChance, float useChance) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        InsolatorCatalyst catalyst = new CRTCatalyst(resourceLocation, ingredient, primaryMod, secondaryMod, energyMod, minChance, useChance).catalyst(InsolatorCatalyst::new);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)catalyst));
    }

    public void removeRecipe(IItemStack output) {
        this.removeCatalyst(output);
    }

    @ZenCodeType.Method
    public void removeCatalyst(IItemStack input) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveThermalCatalystByOutput(this, input));
    }

    public IRecipeType<InsolatorCatalyst> getRecipeType() {
        return TCoreRecipeTypes.CATALYST_INSOLATOR;
    }

    public String dumpToCommandString(IRecipeManager manager, InsolatorCatalyst recipe) {
        return String.format("<recipetype:%s>.addCatalyst(\"%s\", %s, %s, %s, %s, %s, %s);", recipe.func_222127_g(), recipe.func_199560_c(), IIngredient.fromIngredient((Ingredient)recipe.getIngredient()).getCommandString(), Float.valueOf(recipe.getPrimaryMod()), Float.valueOf(recipe.getSecondaryMod()), Float.valueOf(recipe.getEnergyMod()), Float.valueOf(recipe.getMinChance()), Float.valueOf(recipe.getUseChance()));
    }

    public Optional<Function<ResourceLocation, InsolatorCatalyst>> replaceIngredients(IRecipeManager manager, InsolatorCatalyst recipe, List<IReplacementRule> rules) {
        Optional ingredient = IRecipeHandler.attemptReplacing((Object)recipe.getIngredient(), Ingredient.class, (IRecipe)recipe, rules);
        return ingredient.map(value -> id -> new CRTCatalyst((ResourceLocation)id, (Ingredient)value, recipe.getPrimaryMod(), recipe.getSecondaryMod(), recipe.getEnergyMod(), recipe.getMinChance(), recipe.getUseChance()).catalyst(InsolatorCatalyst::new));
    }
}

