/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.pokehaancraftadditions.world;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class PokehaanCraftAdditionsWorldSavedData
extends WorldSavedData {
    private static final String DATA_NAME = "pokehaancraftadd_SAFE";
    private final Map<UUID, Long> healerMap = new HashMap<UUID, Long>();
    private final Map<UUID, Long> upgradedHealerMap = new HashMap<UUID, Long>();
    private final Map<UUID, Long> enchantedEggMap = new HashMap<UUID, Long>();

    public PokehaanCraftAdditionsWorldSavedData() {
        super(DATA_NAME);
    }

    public PokehaanCraftAdditionsWorldSavedData(String s) {
        super(s);
    }

    public void func_76184_a(CompoundNBT nbt) {
        CompoundNBT pokehaancraftaddTag = nbt.func_74775_l("pokehaancraftadd");
        if (pokehaancraftaddTag.func_74764_b("heals")) {
            for (INBT nbtBase : pokehaancraftaddTag.func_150295_c("heals", 10)) {
                CompoundNBT tag = (CompoundNBT)nbtBase;
                UUID uuid = UUID.fromString(tag.func_74779_i("uuid"));
                if (tag.func_74764_b("healer")) {
                    this.healerMap.put(uuid, tag.func_74763_f("healer"));
                }
                if (tag.func_74764_b("upgradedHealer")) {
                    this.upgradedHealerMap.put(uuid, tag.func_74763_f("upgradedHealer"));
                }
                if (!tag.func_74764_b("enchantedEgg")) continue;
                this.enchantedEggMap.put(uuid, tag.func_74763_f("enchantedEgg"));
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        CompoundNBT pokehaancraftaddTag = new CompoundNBT();
        HashSet<UUID> uuidSet = new HashSet<UUID>();
        uuidSet.addAll(this.healerMap.keySet());
        uuidSet.addAll(this.upgradedHealerMap.keySet());
        uuidSet.addAll(this.enchantedEggMap.keySet());
        ListNBT clickTagList = new ListNBT();
        for (UUID key : uuidSet) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("uuid", key.toString());
            tag.func_74772_a("healer", this.healerMap.getOrDefault(key, 0L).longValue());
            tag.func_74772_a("upgradedHealer", this.upgradedHealerMap.getOrDefault(key, 0L).longValue());
            tag.func_74772_a("enchantedEgg", this.enchantedEggMap.getOrDefault(key, 0L).longValue());
            clickTagList.add((Object)tag);
        }
        pokehaancraftaddTag.func_218657_a("heals", (INBT)clickTagList);
        compound.func_218657_a("pokehaancraftadd", (INBT)pokehaancraftaddTag);
        return compound;
    }

    public static PokehaanCraftAdditionsWorldSavedData get(World worldIn) {
        if (!(worldIn instanceof ServerWorld)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        DimensionSavedDataManager storage = ((ServerWorld)worldIn).func_73046_m().func_241755_D_().func_217481_x();
        return (PokehaanCraftAdditionsWorldSavedData)storage.func_215752_a(PokehaanCraftAdditionsWorldSavedData::new, DATA_NAME);
    }

    public long getUpgradedHealerLastUsed(UUID uuid) {
        return this.upgradedHealerMap.getOrDefault(uuid, 0L);
    }

    public void saveUpgradedHealerLastUsed(UUID uuid, long currentTime) {
        this.upgradedHealerMap.put(uuid, currentTime);
        this.func_76185_a();
    }

    public long getHealerLastUsed(UUID uuid) {
        return this.healerMap.getOrDefault(uuid, 0L);
    }

    public void saveHealerLastUsed(UUID uuid, long currentTime) {
        this.healerMap.put(uuid, currentTime);
        this.func_76185_a();
    }

    public long getEnchantedEggLastUsed(UUID uuid) {
        return this.enchantedEggMap.getOrDefault(uuid, 0L);
    }

    public void saveEnchantedEggLastUsed(UUID uuid, long currentTime) {
        this.enchantedEggMap.put(uuid, currentTime);
        this.func_76185_a();
    }
}

