/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.pokehaancraftadditions.network;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class TradeMessage {
    public int selectedOne;
    public int selectedTwo;

    public TradeMessage() {
    }

    public TradeMessage(int selectedOne, int selectedTwo) {
        this.selectedOne = selectedOne;
        this.selectedTwo = selectedTwo;
    }

    public static void encode(TradeMessage message, PacketBuffer buf) {
        buf.writeInt(message.selectedOne);
        buf.writeInt(message.selectedTwo);
    }

    public static TradeMessage decode(PacketBuffer buf) {
        int selectedOne = buf.readInt();
        int selectedTwo = buf.readInt();
        return new TradeMessage(selectedOne, selectedTwo);
    }

    public static void handle(TradeMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        PlayerPartyStorage party = StorageProxy.getParty((ServerPlayerEntity)player);
        party.retrieveAll("BlockInteract");
        Pokemon pokemonOne = party.get(message.selectedOne);
        if (pokemonOne == null || pokemonOne.isEgg()) {
            return;
        }
        Pokemon pokemonTwo = party.get(message.selectedTwo);
        if (pokemonTwo == null || pokemonTwo.isEgg()) {
            return;
        }
        PixelmonEntity pixelmonOne = pokemonOne.getOrSpawnPixelmon((Entity)player);
        pixelmonOne.getPokemon().setFriendship(pixelmonOne.getForm().getSpawn().getBaseFriendship());
        pixelmonOne.update(new EnumUpdateType[]{EnumUpdateType.Friendship});
        PixelmonEntity pixelmonTwo = pokemonTwo.getOrSpawnPixelmon((Entity)player);
        pixelmonTwo.getPokemon().setFriendship(pixelmonTwo.getForm().getSpawn().getBaseFriendship());
        pixelmonTwo.update(new EnumUpdateType[]{EnumUpdateType.Friendship});
        if (!pixelmonOne.testTradeEvolution(pokemonTwo.getSpecies())) {
            pixelmonOne.retrieve("Forced");
        }
        if (!pixelmonTwo.testTradeEvolution(pixelmonOne.getSpecies())) {
            pixelmonTwo.retrieve("Forced");
        }
    }
}

