/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.pokehaancraftadditions.item;

import com.lclc98.pokehaancraftadditions.PokehaanCraftAdditions;
import com.lclc98.pokehaancraftadditions.config.ConfigLoader;
import com.lclc98.pokehaancraftadditions.world.PokehaanCraftAdditionsWorldSavedData;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemUpgradedHealer
extends Item {
    public ItemUpgradedHealer() {
        super(new Item.Properties().func_200916_a(PokehaanCraftAdditions.TABS));
        this.setRegistryName("pokehaancraftadd", "upgraded_healer");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        long lastUsed;
        ItemStack itemstack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        PokehaanCraftAdditionsWorldSavedData savedData = PokehaanCraftAdditionsWorldSavedData.get(world);
        long currentTime = world.func_82737_E();
        if (this.canUse(currentTime, lastUsed = savedData.getUpgradedHealerLastUsed(player.func_110124_au()))) {
            savedData.saveUpgradedHealerLastUsed(player.func_110124_au(), currentTime);
            player.func_145747_a((ITextComponent)new TranslationTextComponent("pokehaancraftadd.healer.healed"), player.func_110124_au());
            PlayerPartyStorage party = StorageProxy.getParty((ServerPlayerEntity)((ServerPlayerEntity)player));
            party.heal();
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        player.func_145747_a((ITextComponent)new TranslationTextComponent("pokehaancraftadd.healer.cooldown", new Object[]{this.getRemaining(currentTime, lastUsed)}), player.func_110124_au());
        return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
    }

    public boolean canUse(long currentTime, long lastUsed) {
        return lastUsed == 0L || currentTime - lastUsed >= (long)ConfigLoader.CONFIG.upgradedHealerCooldown;
    }

    public long getRemaining(long currentTime, long lastUsed) {
        return ((long)ConfigLoader.CONFIG.upgradedHealerCooldown - (currentTime - lastUsed)) / 20L;
    }

    public boolean func_77636_d(ItemStack p_77636_1_) {
        return true;
    }
}

