/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.pokehaancraftadditions.item;

import com.lclc98.pokehaancraftadditions.PokehaanCraftAdditions;
import com.lclc98.pokehaancraftadditions.config.ConfigLoader;
import com.lclc98.pokehaancraftadditions.world.PokehaanCraftAdditionsWorldSavedData;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemEnchantedEgg
extends Item {
    public ItemEnchantedEgg() {
        super(new Item.Properties().func_200916_a(PokehaanCraftAdditions.TABS).func_200917_a(1));
        this.setRegistryName("pokehaancraftadd", "enchanted_egg");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        PokehaanCraftAdditionsWorldSavedData savedData;
        long lastFed;
        if (worldIn.field_72995_K) {
            return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184586_b(handIn));
        }
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        long currentTime = worldIn.func_82737_E();
        if (this.canUse(currentTime, lastFed = (savedData = PokehaanCraftAdditionsWorldSavedData.get(worldIn)).getEnchantedEggLastUsed(playerIn.func_110124_au()))) {
            Ingredient consumableIngredient = ConfigLoader.CONFIG.getEnchantedEggConsumable();
            if (this.consumeIngredient(playerIn, consumableIngredient)) {
                savedData.saveEnchantedEggLastUsed(playerIn.func_110124_au(), currentTime);
                this.spawnRandomPokemon(worldIn, playerIn);
                return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
            }
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("pokehaancraftadd.enchanted_egg.no_food", new Object[]{new TranslationTextComponent(consumableIngredient.func_193365_a()[0].func_77977_a())}), true);
        } else {
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("pokehaancraftadd.enchanted_egg.cooldown", new Object[]{this.getRemaining(currentTime, lastFed)}), true);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
    }

    public boolean consumeIngredient(PlayerEntity player, Ingredient consumableIngredient) {
        NonNullList inv = player.field_71071_by.field_70462_a;
        for (ItemStack stack : inv) {
            if (!consumableIngredient.test(stack)) continue;
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public void spawnRandomPokemon(World world, PlayerEntity player) {
        Pokemon species = PokemonBuilder.builder().randomSpecies(true, true, true).build();
        species.getOrSpawnPixelmon(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
    }

    public boolean canUse(long currentTime, long lastFed) {
        return lastFed == 0L || currentTime - lastFed >= (long)ConfigLoader.CONFIG.enchantedEggCooldown;
    }

    public long getRemaining(long currentTime, long lastFed) {
        return ((long)ConfigLoader.CONFIG.enchantedEggCooldown - (currentTime - lastFed)) / 20L;
    }
}

