/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.pokehaancraftadditions.client.renderer.tileentity;

import com.lclc98.pokehaancraftadditions.block.TrophyBlock;
import com.lclc98.pokehaancraftadditions.block.TrophyTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class TrophyTileEntityRenderer
extends TileEntityRenderer<TrophyTileEntity> {
    private static final Random RANDOM = new Random();

    public TrophyTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TrophyTileEntity te, float partial, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay) {
        BlockState state = te.func_195044_w();
        World world = te.func_145831_w();
        BlockPos pos = te.func_174877_v();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = dispatcher.func_184389_a(state);
        IModelData modelData = ModelDataManager.getModelData((World)world, (BlockPos)pos);
        if (modelData == null) {
            modelData = model.getModelData((IBlockDisplayReader)world, pos, state, (IModelData)EmptyModelData.INSTANCE);
        }
        TrophyBlock.Variant variant = null;
        matrix.func_227860_a_();
        if (modelData.hasProperty(TrophyTileEntity.VARIANT_STATE)) {
            variant = (TrophyBlock.Variant)((Object)modelData.getData(TrophyTileEntity.VARIANT_STATE));
        }
        if (variant == null) {
            variant = TrophyBlock.Variant.RED;
        }
        matrix.func_227861_a_((double)variant.translate, 0.0, (double)variant.translate);
        matrix.func_227862_a_(variant.scale, variant.scale, variant.scale);
        ForgeHooksClient.setRenderLayer((RenderType)RenderType.func_228643_e_());
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228643_e_());
        this.renderModel(dispatcher.func_175019_b(), world, model, modelData, state, pos, matrix, builder);
        ForgeHooksClient.setRenderLayer(null);
        matrix.func_227865_b_();
    }

    public void renderModel(BlockModelRenderer renderer, World world, IBakedModel model, IModelData modelData, BlockState state, BlockPos pos, MatrixStack matrix, IVertexBuilder buffer) {
        BitSet bitset = new BitSet(3);
        for (Direction direction : Direction.values()) {
            RANDOM.setSeed(state.func_209533_a(pos));
            List list = model.getQuads(state, direction, RANDOM, modelData);
            if (list.isEmpty() || !Block.func_176225_a((BlockState)state, (IBlockReader)world, (BlockPos)pos, (Direction)direction)) continue;
            int lightForSide = WorldRenderer.func_228420_a_((IBlockDisplayReader)world, (BlockState)state, (BlockPos)pos.func_177972_a(direction));
            renderer.func_228798_a_((IBlockDisplayReader)world, state, pos, lightForSide, OverlayTexture.field_229196_a_, false, matrix, buffer, list, bitset);
        }
        RANDOM.setSeed(state.func_209533_a(pos));
        List list1 = model.getQuads(state, null, RANDOM, modelData);
        if (!list1.isEmpty()) {
            renderer.func_228798_a_((IBlockDisplayReader)world, state, pos, -1, OverlayTexture.field_229196_a_, true, matrix, buffer, list1, bitset);
        }
    }
}

