/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.pokehaancraftadditions.block;

import com.lclc98.pokehaancraftadditions.block.TrophyTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TrophyBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private final Variant variant;

    public TrophyBlock(Variant variant) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)variant.materialColor).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        this.setRegistryName(new ResourceLocation("pokehaancraftadd", "trophy_" + variant.name));
        this.variant = variant;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f();
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TrophyTileEntity) {
            BlockItem blockItem;
            TrophyTileEntity trophyTileEntity = (TrophyTileEntity)te;
            if (stack.func_77973_b() instanceof BlockItem && (blockItem = (BlockItem)stack.func_77973_b()).func_179223_d() instanceof TrophyBlock) {
                TrophyBlock trophyBlock = (TrophyBlock)blockItem.func_179223_d();
                trophyTileEntity.setVariant(trophyBlock.getVariant());
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        float size = ((TrophyBlock)state.func_177230_c()).variant.size;
        float xy1 = size / 16.0f / 2.0f - 0.5f;
        float xy2 = size / 16.0f / 2.0f + 0.5f;
        return VoxelShapes.func_197873_a((double)(-xy1), (double)0.0, (double)(-xy1), (double)xy2, (double)(size / 8.0f), (double)xy2);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader p_199600_2_, BlockPos p_199600_3_) {
        float size = ((TrophyBlock)state.func_177230_c()).variant.size;
        float xy1 = size / 16.0f / 2.0f - 0.5f;
        float xy2 = size / 16.0f / 2.0f + 0.5f;
        return VoxelShapes.func_197873_a((double)(-xy1), (double)0.0, (double)(-xy1), (double)xy2, (double)(size / 8.0f), (double)xy2);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader reader) {
        return new TrophyTileEntity();
    }

    public static enum Variant {
        RED(MaterialColor.field_151645_D, "red", 4.0f),
        BLUE(MaterialColor.field_151649_A, "blue", 6.0f),
        YELLOW(MaterialColor.field_151673_t, "yellow", 8.0f),
        PURPLE(MaterialColor.field_151678_z, "purple", 12.0f),
        SOUL_SAND(MaterialColor.field_151650_B, "soul_sand", 16.0f);

        private static final float PIXEL_BLOCK = 16.0f;
        private static final float BASE_SIZE = 8.0f;
        private static final float BASE_BLOCK_RATIO = 0.5f;
        private final MaterialColor materialColor;
        private final String name;
        public final float size;
        public final float translate;
        public final float scale;

        private Variant(MaterialColor materialColor, String name, float size) {
            this.name = name;
            this.materialColor = materialColor;
            this.size = size;
            this.translate = 0.5f - size / 16.0f;
            this.scale = size / 16.0f / 0.5f;
        }

        public String getName() {
            return this.name;
        }
    }
}

