/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.gen.placement.IPlacementConfig;

public class BridgePlacementConfig
implements IPlacementConfig {
    public static final Codec<BridgePlacementConfig> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.INT.fieldOf("length").forGetter(config -> config.length), (App)Codec.INT.fieldOf("width").forGetter(config -> config.width), (App)Codec.INT.fieldOf("minWaterZ").forGetter(config -> config.minWaterZ), (App)Codec.INT.fieldOf("maxWaterZ").forGetter(config -> config.maxWaterZ), (App)Codec.INT.fieldOf("widthOffset").forGetter(config -> config.widthOffset), (App)Codec.INT.fieldOf("numSolidBlocksNeeded").forGetter(config -> config.numSolidBlocksNeeded), (App)Codec.BOOL.fieldOf("northSouth").forGetter(config -> config.northSouth)).apply((Applicative)codec, BridgePlacementConfig::new));
    public final int length;
    public final int width;
    public final int minWaterZ;
    public final int maxWaterZ;
    public int widthOffset;
    public int numSolidBlocksNeeded;
    public boolean northSouth;

    public BridgePlacementConfig(int length, int width, int minWaterZ, int maxWaterZ, int widthOffset, int numSolidBlocksNeeded, boolean northSouth) {
        this.length = length;
        this.width = width;
        this.minWaterZ = minWaterZ;
        this.maxWaterZ = maxWaterZ;
        this.widthOffset = widthOffset;
        this.numSolidBlocksNeeded = numSolidBlocksNeeded;
        this.northSouth = northSouth;
    }

    public BridgePlacementConfig(int length, int width, int minWaterZ, int maxWaterZ) {
        this(length, width, minWaterZ, maxWaterZ, 0, 1, true);
    }

    public BridgePlacementConfig(BridgePlacementConfig other) {
        this(other.length, other.width, other.minWaterZ, other.maxWaterZ, other.widthOffset, other.numSolidBlocksNeeded, other.northSouth);
    }

    public BridgePlacementConfig widthOffset(int widthOffset) {
        this.widthOffset = widthOffset;
        return this;
    }

    public BridgePlacementConfig solidBlocks(int numSolidBlocksNeeded) {
        this.numSolidBlocksNeeded = numSolidBlocksNeeded;
        return this;
    }

    public BridgePlacementConfig rotatedCopy() {
        BridgePlacementConfig configCopy = new BridgePlacementConfig(this);
        configCopy.northSouth = !this.northSouth;
        return configCopy;
    }
}

