/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.world.placement;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.yungsbridges.world.placement.BridgePlacementConfig;
import java.util.Iterator;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.WorldDecoratingHelper;
import net.minecraft.world.gen.placement.Placement;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BridgePlacement
extends Placement<BridgePlacementConfig> {
    public BridgePlacement() {
        super(BridgePlacementConfig.CODEC);
    }

    public Stream<BlockPos> getPositions(WorldDecoratingHelper helper, Random rand, BridgePlacementConfig config, BlockPos pos) {
        BlockPos.Mutable seaLevelMutable = pos.func_239590_i_();
        int seaLevel = helper.func_242895_b() - 1;
        seaLevelMutable.func_185336_p(seaLevel);
        for (int candidateMiddleMinorAxisOffset = config.width / 2 + config.widthOffset + 1; candidateMiddleMinorAxisOffset < 16 - config.width / 2 - config.widthOffset; ++candidateMiddleMinorAxisOffset) {
            for (int candidateStartMajorAxisOffset = 0; candidateStartMajorAxisOffset < 16; ++candidateStartMajorAxisOffset) {
                int minorAxisSolidOffset;
                int minorAxisSolidDist;
                int direction;
                BlockPos endingPos;
                BlockPos startingPos = config.northSouth ? new BlockPos(pos.func_177958_n() + candidateMiddleMinorAxisOffset, seaLevel, pos.func_177952_p() + candidateStartMajorAxisOffset) : new BlockPos(pos.func_177958_n() + candidateStartMajorAxisOffset, seaLevel, pos.func_177952_p() + candidateMiddleMinorAxisOffset);
                BlockPos blockPos = endingPos = config.northSouth ? new BlockPos(pos.func_177958_n() + candidateMiddleMinorAxisOffset, seaLevel, pos.func_177952_p() + candidateStartMajorAxisOffset + config.length + 1) : new BlockPos(pos.func_177958_n() + candidateStartMajorAxisOffset + config.length + 1, seaLevel, pos.func_177952_p() + candidateMiddleMinorAxisOffset);
                if (!helper.func_242894_a(startingPos).func_200132_m() || !helper.func_242894_a(endingPos).func_200132_m() || helper.func_242893_a(Heightmap.Type.WORLD_SURFACE, startingPos.func_177958_n(), startingPos.func_177952_p()) > seaLevel + 1 || helper.func_242893_a(Heightmap.Type.WORLD_SURFACE, endingPos.func_177958_n(), endingPos.func_177952_p()) > seaLevel + 1) continue;
                int numSolidBlocks = 1;
                Iterator iterator = Lists.newArrayList((Object[])new Integer[]{-1, 1}).iterator();
                block2: while (iterator.hasNext()) {
                    direction = (Integer)iterator.next();
                    for (minorAxisSolidDist = 1; minorAxisSolidDist <= config.width / 2; ++minorAxisSolidDist) {
                        minorAxisSolidOffset = direction * minorAxisSolidDist;
                        if (config.northSouth) {
                            seaLevelMutable.func_181079_c(startingPos.func_177958_n() + minorAxisSolidOffset, startingPos.func_177956_o(), startingPos.func_177952_p());
                        } else {
                            seaLevelMutable.func_181079_c(startingPos.func_177958_n(), startingPos.func_177956_o(), startingPos.func_177952_p() + minorAxisSolidOffset);
                        }
                        if (!helper.func_242894_a((BlockPos)seaLevelMutable).func_200132_m() || helper.func_242893_a(Heightmap.Type.WORLD_SURFACE, seaLevelMutable.func_177958_n(), seaLevelMutable.func_177952_p()) > seaLevel + 1) continue block2;
                        ++numSolidBlocks;
                    }
                }
                if (numSolidBlocks < config.numSolidBlocksNeeded) continue;
                numSolidBlocks = 1;
                iterator = Lists.newArrayList((Object[])new Integer[]{-1, 1}).iterator();
                block4: while (iterator.hasNext()) {
                    direction = (Integer)iterator.next();
                    for (minorAxisSolidDist = 1; minorAxisSolidDist <= config.width / 2; ++minorAxisSolidDist) {
                        minorAxisSolidOffset = direction * minorAxisSolidDist;
                        if (config.northSouth) {
                            seaLevelMutable.func_181079_c(endingPos.func_177958_n() + minorAxisSolidOffset, endingPos.func_177956_o(), endingPos.func_177952_p());
                        } else {
                            seaLevelMutable.func_181079_c(endingPos.func_177958_n(), endingPos.func_177956_o(), endingPos.func_177952_p() + minorAxisSolidOffset);
                        }
                        if (!helper.func_242894_a((BlockPos)seaLevelMutable).func_200132_m() || helper.func_242893_a(Heightmap.Type.WORLD_SURFACE, seaLevelMutable.func_177958_n(), seaLevelMutable.func_177952_p()) > seaLevel + 1) continue block4;
                        ++numSolidBlocks;
                    }
                }
                if (numSolidBlocks < config.numSolidBlocksNeeded) continue;
                boolean isAllWater = true;
                block6: for (int minorAxisWaterOffset = -config.width / 2; minorAxisWaterOffset <= config.width / 2; ++minorAxisWaterOffset) {
                    for (int majorAxisWaterOffset = config.minWaterZ; majorAxisWaterOffset <= config.maxWaterZ; ++majorAxisWaterOffset) {
                        if (config.northSouth) {
                            seaLevelMutable.func_181079_c(startingPos.func_177958_n() + minorAxisWaterOffset, seaLevel, startingPos.func_177952_p() + majorAxisWaterOffset);
                        } else {
                            seaLevelMutable.func_181079_c(startingPos.func_177958_n() + majorAxisWaterOffset, seaLevel, startingPos.func_177952_p() + minorAxisWaterOffset);
                        }
                        if (helper.func_242894_a((BlockPos)seaLevelMutable).func_185904_a() == Material.field_151586_h) continue;
                        isAllWater = false;
                        continue block6;
                    }
                }
                if (!isAllWater) continue;
                return config.northSouth ? Stream.of(new BlockPos(startingPos.func_177958_n() - config.width / 2 - config.widthOffset, seaLevel, startingPos.func_177952_p() + 1)) : Stream.of(new BlockPos(startingPos.func_177958_n() + 1, seaLevel, startingPos.func_177952_p() + config.width / 2 + config.widthOffset));
            }
        }
        return Stream.empty();
    }
}

