/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.world.feature;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.yungsbridges.init.YBModProcessors;
import com.yungnickyoung.minecraft.yungsbridges.world.feature.AbstractTemplateFeature;
import com.yungnickyoung.minecraft.yungsbridges.world.feature.BridgeFeatureConfig;
import com.yungnickyoung.minecraft.yungsbridges.world.processor.ITemplateFeatureProcessor;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class BridgeFeature
extends AbstractTemplateFeature<BridgeFeatureConfig> {
    private static final List<ITemplateFeatureProcessor> PROCESSORS = Lists.newArrayList((Object[])new ITemplateFeatureProcessor[]{YBModProcessors.LEG_PROCESSOR, YBModProcessors.LOG_BIOME_PROCESSOR, YBModProcessors.STAIR_BIOME_PROCESSOR, YBModProcessors.PLANKS_BIOME_PROCESSOR, YBModProcessors.SLAB_BIOME_PROCESSOR, YBModProcessors.STONE_VARIATION_PROCESSOR, YBModProcessors.LANTERN_ROT_PROCESSOR, YBModProcessors.OPTIONAL_WALL_PROCESSOR, YBModProcessors.OPTIONAL_STONE_BRICK_PROCESSOR, YBModProcessors.OPTIONAL_SLAB_PROCESSOR, YBModProcessors.OPTIONAL_STAIR_PROCESSOR, YBModProcessors.FENCE_BIOME_PROCESSOR});

    public BridgeFeature() {
        super(BridgeFeatureConfig.CODEC);
    }

    @Override
    protected List<ITemplateFeatureProcessor> useProcessors() {
        return PROCESSORS;
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos pos, BridgeFeatureConfig config) {
        Template template;
        BlockPos.Mutable startPos = pos.func_239590_i_();
        startPos.func_185336_p(world.func_181545_F());
        PlacementSettings placementSettings = new PlacementSettings();
        if (!config.northSouth) {
            placementSettings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
        }
        return (template = this.createTemplateWithPlacement(config.id, world, rand, (BlockPos)startPos, placementSettings)) != null;
    }
}

