/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public class FilterModuleCache
implements Predicate<ItemStack> {
    private boolean matchDamage = true;
    private boolean blacklistMode = true;
    private boolean nbtMode = false;
    private boolean modMode = false;
    private ItemStackList stacks;
    private Set<ResourceLocation> tags = Collections.emptySet();

    public FilterModuleCache(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            this.matchDamage = tagCompound.func_74767_n("damageMode");
            this.nbtMode = tagCompound.func_74767_n("nbtMode");
            this.modMode = tagCompound.func_74767_n("modMode");
            this.blacklistMode = "Black".equals(tagCompound.func_74779_i("blacklistMode"));
            FilterModuleInventory inventory = new FilterModuleInventory(stack);
            this.tags = new HashSet<ResourceLocation>();
            this.stacks = ItemStackList.create();
            this.stacks.addAll(inventory.getStacks());
            this.tags.addAll(inventory.getTags());
        } else {
            this.stacks = ItemStackList.EMPTY;
        }
    }

    @Override
    public boolean test(ItemStack stack) {
        if (!stack.func_190926_b()) {
            boolean match = false;
            String modName = "";
            if (this.modMode) {
                modName = stack.func_77973_b().getRegistryName().func_110624_b();
            }
            if (!this.tags.isEmpty()) {
                for (ResourceLocation tag : stack.func_77973_b().getTags()) {
                    if (!this.tags.contains(tag)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) {
                match = this.itemMatches(stack, modName);
            }
            return match != this.blacklistMode;
        }
        return false;
    }

    private boolean itemMatches(ItemStack stack, String modName) {
        if (this.stacks != null) {
            for (ItemStack itemStack : this.stacks) {
                if (this.matchDamage && itemStack.func_77952_i() != stack.func_77952_i() || this.nbtMode && !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)stack) || !(this.modMode ? modName.equals(itemStack.func_77973_b().getRegistryName().func_110624_b()) : itemStack.func_77973_b().equals(stack.func_77973_b()))) continue;
                return true;
            }
        }
        return false;
    }
}

