/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.roguelogix.biggerreactors.multiblocks.reactor.ReactorMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorRedstonePort;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorRedstonePortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorActivity;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorRedstonePortSelection;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorRedstonePortState;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorRedstonePortTriggers;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorBaseTile;
import net.roguelogix.phosphophyllite.gui.client.api.IHasUpdatableState;
import net.roguelogix.phosphophyllite.multiblock.generic.IOnAssemblyTile;
import net.roguelogix.phosphophyllite.multiblock.generic.IOnDisassemblyTile;
import net.roguelogix.phosphophyllite.multiblock.generic.ITickableMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockBlock;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.registry.TileSupplier;
import net.roguelogix.phosphophyllite.util.BlockStates;

@RegisterTileEntity(name="reactor_redstone_port")
public class ReactorRedstonePortTile
extends ReactorBaseTile
implements INamedContainerProvider,
ITickableMultiblockTile,
IHasUpdatableState<ReactorRedstonePortState>,
IOnAssemblyTile,
IOnDisassemblyTile {
    @RegisterTileEntity.Type
    public static TileEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final TileSupplier SUPPLIER;
    public final ReactorRedstonePortState reactorRedstonePortState = new ReactorRedstonePortState(this);
    private boolean isEmitting;
    double mainVal = 0.0;
    double secondaryVal = 0.0;
    Direction powerOutputDirection = null;
    private boolean isPowered = false;
    private boolean wasPowered = false;
    private boolean isLit = false;
    private final ReactorRedstonePortState currentChanges = new ReactorRedstonePortState(this);

    public ReactorRedstonePortTile() {
        super(TYPE);
    }

    public boolean isEmitting(Direction side) {
        if (side.func_176734_d() != this.powerOutputDirection) {
            return false;
        }
        return this.isEmitting;
    }

    public void updatePowered() {
        if (this.powerOutputDirection == null) {
            return;
        }
        assert (this.field_145850_b != null);
        this.isPowered = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(this.powerOutputDirection), this.powerOutputDirection) > 0;
    }

    public void tick() {
        boolean shouldBeEmitting = false;
        boolean shouldLight = false;
        block0 : switch (this.reactorRedstonePortState.selectedTab) {
            case INPUT_ACTIVITY: {
                shouldLight = this.isPowered;
                if (this.reactorRedstonePortState.triggerPS.toBool()) {
                    if (this.wasPowered == this.isPowered) break;
                    ((ReactorMultiblockController)this.controller).setActive(this.isPowered ? ReactorActivity.ACTIVE : ReactorActivity.INACTIVE);
                    break;
                }
                if (this.wasPowered || !this.isPowered) break;
                ((ReactorMultiblockController)this.controller).toggleActive();
                break;
            }
            case INPUT_CONTROL_ROD_INSERTION: {
                shouldLight = this.isPowered;
                if (this.reactorRedstonePortState.triggerPS.toBool()) {
                    if (this.wasPowered == this.isPowered) break;
                    if (this.isPowered) {
                        ((ReactorMultiblockController)this.controller).setAllControlRodLevels(this.mainVal);
                        break;
                    }
                    ((ReactorMultiblockController)this.controller).setAllControlRodLevels(this.secondaryVal);
                    break;
                }
                if (this.wasPowered || !this.isPowered) break;
                switch (this.reactorRedstonePortState.triggerMode) {
                    case 0: {
                        ((ReactorMultiblockController)this.controller).setAllControlRodLevels(((ReactorMultiblockController)this.controller).controlRodLevel(0) + this.mainVal);
                        break block0;
                    }
                    case 1: {
                        ((ReactorMultiblockController)this.controller).setAllControlRodLevels(((ReactorMultiblockController)this.controller).controlRodLevel(0) - this.mainVal);
                        break block0;
                    }
                    case 2: {
                        ((ReactorMultiblockController)this.controller).setAllControlRodLevels(this.mainVal);
                        break block0;
                    }
                }
                break;
            }
            case INPUT_EJECT_WASTE: {
                shouldLight = this.isPowered;
                if (this.wasPowered || !this.isPowered) break;
                ((ReactorMultiblockController)this.controller).ejectWaste();
                break;
            }
            case OUTPUT_FUEL_TEMP: {
                double fuelTemp = ((ReactorMultiblockController)this.controller).simulation().fuelHeat();
                if (fuelTemp < this.mainVal != this.reactorRedstonePortState.triggerAB.toBool()) break;
                shouldBeEmitting = true;
                break;
            }
            case OUTPUT_CASING_TEMP: {
                double casingTemperature = ((ReactorMultiblockController)this.controller).simulation().caseHeat();
                if (casingTemperature < this.mainVal != this.reactorRedstonePortState.triggerAB.toBool()) break;
                shouldBeEmitting = true;
                break;
            }
            case OUTPUT_FUEL_ENRICHMENT: {
                double fuelPercent = ((ReactorMultiblockController)this.controller).simulation().fuelTank().fuel();
                fuelPercent /= (double)((ReactorMultiblockController)this.controller).simulation().fuelTank().totalStored();
                if ((fuelPercent *= 100.0) < this.mainVal != this.reactorRedstonePortState.triggerAB.toBool()) break;
                shouldBeEmitting = true;
                break;
            }
            case OUTPUT_FUEL_AMOUNT: {
                double fuelAmount = ((ReactorMultiblockController)this.controller).simulation().fuelTank().fuel();
                if (fuelAmount < this.mainVal != this.reactorRedstonePortState.triggerAB.toBool()) break;
                shouldBeEmitting = true;
                break;
            }
            case OUTPUT_WASTE_AMOUNT: {
                double wasteAmount = ((ReactorMultiblockController)this.controller).simulation().fuelTank().waste();
                if (wasteAmount < this.mainVal != this.reactorRedstonePortState.triggerAB.toBool()) break;
                shouldBeEmitting = true;
                break;
            }
            case OUTPUT_ENERGY_AMOUNT: {
                double energyAmount = ((ReactorMultiblockController)this.controller).simulation().battery().stored();
                energyAmount /= (double)((ReactorMultiblockController)this.controller).simulation().battery().capacity();
                if ((energyAmount *= 100.0) < this.mainVal != this.reactorRedstonePortState.triggerAB.toBool()) break;
                shouldBeEmitting = true;
            }
        }
        shouldLight |= shouldBeEmitting;
        if (shouldBeEmitting != this.isEmitting || this.wasPowered != this.isPowered) {
            this.isEmitting = shouldBeEmitting;
            this.wasPowered = this.isPowered;
            assert (this.field_145850_b != null);
            BlockPos updatePos = this.field_174879_c.func_177972_a(this.powerOutputDirection);
            this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
            this.field_145850_b.func_195593_d(updatePos, this.field_145850_b.func_180495_p(updatePos).func_177230_c());
        }
        if (this.isLit != shouldLight) {
            this.isLit = shouldLight;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)ReactorRedstonePort.IS_LIT_BOOLEAN_PROPERTY, (Comparable)Boolean.valueOf(this.isLit)));
        }
        this.func_70296_d();
    }

    @Nonnull
    public ActionResultType onBlockActivated(@Nonnull PlayerEntity player, @Nonnull Hand handIn) {
        assert (this.field_145850_b != null);
        if (((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)MultiblockBlock.ASSEMBLED)).booleanValue()) {
            if (!this.field_145850_b.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.func_174877_v());
            }
            return ActionResultType.SUCCESS;
        }
        return super.onBlockActivated(player, handIn);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(ReactorRedstonePort.INSTANCE.func_149739_a());
    }

    @Nullable
    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
        return new ReactorRedstonePortContainer(windowId, this.field_174879_c, player);
    }

    public ReactorRedstonePortState getCurrentChanges() {
        return this.currentChanges;
    }

    @Nonnull
    public ReactorRedstonePortState getState() {
        this.updateState();
        return this.reactorRedstonePortState;
    }

    public void updateState() {
    }

    public void applyChanges() {
        this.reactorRedstonePortState.selectedTab = this.currentChanges.selectedTab;
        this.reactorRedstonePortState.triggerPS = this.currentChanges.triggerPS;
        this.reactorRedstonePortState.triggerAB = this.currentChanges.triggerAB;
        this.reactorRedstonePortState.triggerMode = this.currentChanges.triggerMode;
        this.reactorRedstonePortState.textBufferA = this.currentChanges.textBufferA;
        this.reactorRedstonePortState.textBufferB = this.currentChanges.textBufferB;
        this.mainVal = !this.reactorRedstonePortState.textBufferA.isEmpty() ? Double.parseDouble(this.reactorRedstonePortState.textBufferA) : 0.0;
        this.secondaryVal = !this.reactorRedstonePortState.textBufferB.isEmpty() ? Double.parseDouble(this.reactorRedstonePortState.textBufferB) : 0.0;
    }

    public void revertChanges() {
        this.currentChanges.selectedTab = this.reactorRedstonePortState.selectedTab;
        this.currentChanges.triggerPS = this.reactorRedstonePortState.triggerPS;
        this.currentChanges.triggerAB = this.reactorRedstonePortState.triggerAB;
        this.currentChanges.triggerMode = this.reactorRedstonePortState.triggerMode;
        this.currentChanges.textBufferA = this.reactorRedstonePortState.textBufferA;
        this.currentChanges.textBufferB = this.reactorRedstonePortState.textBufferB;
    }

    @Override
    public void runRequest(String requestName, Object requestData) {
        switch (requestName) {
            case "setSelectedTab": {
                this.currentChanges.selectedTab = ReactorRedstonePortSelection.fromInt((Integer)requestData);
                break;
            }
            case "setTriggerPS": {
                this.currentChanges.triggerPS = ReactorRedstonePortTriggers.fromBool((Boolean)requestData);
                break;
            }
            case "setTriggerAB": {
                this.currentChanges.triggerAB = ReactorRedstonePortTriggers.fromBool((Boolean)requestData);
                break;
            }
            case "setTriggerMode": {
                int triggerMode = (Integer)requestData;
                if (triggerMode >= 0 && triggerMode <= 2) {
                    this.currentChanges.triggerMode = triggerMode;
                    break;
                }
                this.currentChanges.triggerMode = 2;
                break;
            }
            case "setTextBufferA": {
                this.currentChanges.textBufferA = (String)requestData;
                break;
            }
            case "setTextBufferB": {
                this.currentChanges.textBufferB = (String)requestData;
                break;
            }
            case "revertChanges": {
                System.out.println("No longer implemented!");
                break;
            }
            case "applyChanges": {
                this.applyChanges();
                break;
            }
            default: {
                super.runRequest(requestName, requestData);
            }
        }
    }

    @Nonnull
    protected CompoundNBT writeNBT() {
        CompoundNBT compound = super.writeNBT();
        compound.func_74768_a("settingId", this.reactorRedstonePortState.selectedTab.toInt());
        compound.func_74757_a("triggerPulseOrSignal", this.reactorRedstonePortState.triggerPS.toBool());
        compound.func_74757_a("triggerAboveOrBelow", this.reactorRedstonePortState.triggerAB.toBool());
        compound.func_74768_a("mode", this.reactorRedstonePortState.triggerMode);
        compound.func_74778_a("mainBuffer", this.reactorRedstonePortState.textBufferA);
        compound.func_74778_a("secondBuffer", this.reactorRedstonePortState.textBufferB);
        compound.func_74757_a("isPowered", this.isPowered);
        compound.func_74757_a("isEmitting", this.isEmitting);
        return compound;
    }

    protected void readNBT(@Nonnull CompoundNBT compound) {
        super.readNBT(compound);
        if (compound.func_74764_b("settingId")) {
            this.reactorRedstonePortState.selectedTab = ReactorRedstonePortSelection.fromInt(compound.func_74762_e("settingId"));
        }
        if (compound.func_74764_b("triggerPulseOrSignal")) {
            this.reactorRedstonePortState.triggerPS = ReactorRedstonePortTriggers.fromBool(compound.func_74767_n("triggerPulseOrSignal"));
        }
        if (compound.func_74764_b("triggerAboveOrBelow")) {
            this.reactorRedstonePortState.triggerAB = ReactorRedstonePortTriggers.fromBool(compound.func_74767_n("triggerAboveOrBelow"));
        }
        if (compound.func_74764_b("mode")) {
            this.reactorRedstonePortState.triggerMode = compound.func_74762_e("mode");
        }
        if (compound.func_74764_b("mainBuffer")) {
            this.reactorRedstonePortState.textBufferA = compound.func_74779_i("mainBuffer");
        }
        if (compound.func_74764_b("secondBuffer")) {
            this.reactorRedstonePortState.textBufferB = compound.func_74779_i("secondBuffer");
        }
        if (compound.func_74764_b("isPowered")) {
            this.wasPowered = this.isPowered = compound.func_74767_n("isPowered");
        }
        this.revertChanges();
        this.applyChanges();
    }

    public void onAssembly() {
        this.powerOutputDirection = (Direction)this.func_195044_w().func_177229_b((Property)BlockStates.FACING);
        this.updatePowered();
    }

    public void onDisassembly() {
        this.powerOutputDirection = null;
        this.updatePowered();
    }

    static {
        SUPPLIER = ReactorRedstonePortTile::new;
    }
}

