/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.modern;

import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorCoolantTank;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.biggerreactors.util.FluidTransitionTank;

public class CoolantTank
extends FluidTransitionTank
implements IReactorCoolantTank,
ReactorModeratorRegistry.IModeratorProperties {
    private ReactorModeratorRegistry.IModeratorProperties airProperties = ReactorModeratorRegistry.EMPTY_MODERATOR;
    private ReactorModeratorRegistry.IModeratorProperties liquidProperties = ReactorModeratorRegistry.EMPTY_MODERATOR;

    public CoolantTank() {
        super(false);
        this.transitionUpdate();
    }

    @Override
    public void dumpLiquid() {
        this.dumpTank(0);
    }

    @Override
    public void dumpVapor() {
        this.dumpTank(1);
    }

    @Override
    protected void transitionUpdate() {
        this.airProperties = ReactorModeratorRegistry.blockModeratorProperties(Blocks.field_150350_a);
        if (this.airProperties == null) {
            this.airProperties = ReactorModeratorRegistry.EMPTY_MODERATOR;
        }
        this.liquidProperties = this.airProperties;
        Fluid liquid = this.inFluid;
        if (liquid != null) {
            this.liquidProperties = ReactorModeratorRegistry.blockModeratorProperties(liquid.func_207188_f().func_206883_i().func_177230_c());
            if (this.liquidProperties == null) {
                this.liquidProperties = this.airProperties;
            }
        }
    }

    @Override
    public double absorption() {
        if (this.perSideCapacity == 0L) {
            return this.airProperties.absorption();
        }
        double absorption = 0.0;
        absorption += this.airProperties.absorption() * (double)(this.perSideCapacity - this.inAmount);
        absorption += this.liquidProperties.absorption() * (double)this.inAmount;
        return absorption /= (double)this.perSideCapacity;
    }

    @Override
    public double heatEfficiency() {
        if (this.perSideCapacity == 0L) {
            return this.airProperties.heatEfficiency();
        }
        double heatEfficiency = 0.0;
        heatEfficiency += this.airProperties.heatEfficiency() * (double)(this.perSideCapacity - this.inAmount);
        heatEfficiency += this.liquidProperties.heatEfficiency() * (double)this.inAmount;
        return heatEfficiency /= (double)this.perSideCapacity;
    }

    @Override
    public double moderation() {
        if (this.perSideCapacity == 0L) {
            return this.airProperties.moderation();
        }
        double moderation = 0.0;
        moderation += this.airProperties.moderation() * (double)(this.perSideCapacity - this.inAmount);
        moderation += this.liquidProperties.moderation() * (double)this.inAmount;
        return moderation /= (double)this.perSideCapacity;
    }

    @Override
    public double heatConductivity() {
        if (this.perSideCapacity == 0L) {
            return this.airProperties.heatConductivity();
        }
        double heatConductivity = 0.0;
        heatConductivity += this.airProperties.heatConductivity() * (double)(this.perSideCapacity - this.inAmount);
        heatConductivity += this.liquidProperties.heatConductivity() * (double)this.inAmount;
        return heatConductivity /= (double)this.perSideCapacity;
    }
}

