/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.experimental;

import net.minecraft.nbt.CompoundNBT;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorFuelTank;

public class FuelTank
implements IReactorFuelTank {
    private long capacity;
    private long fuel = 0L;
    private long waste = 0L;
    private double partialUsed = 0.0;

    void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    double burn(double amount) {
        if (Double.isInfinite(amount) || Double.isNaN(amount)) {
            return 0.0;
        }
        double toProcess = this.partialUsed + amount;
        toProcess = Math.min(toProcess, (double)this.fuel);
        double burnedThisTick = toProcess - this.partialUsed;
        this.partialUsed = toProcess;
        if (toProcess >= 1.0) {
            long toBurn = (long)toProcess;
            this.fuel -= toBurn;
            this.waste += toBurn;
            this.partialUsed -= (double)toBurn;
        }
        return burnedThisTick;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long totalStored() {
        return this.fuel + this.waste;
    }

    @Override
    public long fuel() {
        return this.fuel;
    }

    @Override
    public long waste() {
        return this.waste;
    }

    @Override
    public long insertFuel(long amount, boolean simulated) {
        if (this.totalStored() >= this.capacity) {
            return 0L;
        }
        amount = Math.min(amount, this.capacity - this.totalStored());
        if (!simulated) {
            this.fuel += amount;
        }
        return amount;
    }

    @Override
    public long insertWaste(long amount, boolean simulated) {
        if (this.totalStored() >= this.capacity) {
            return 0L;
        }
        amount = Math.min(amount, this.capacity - this.totalStored());
        if (!simulated) {
            this.waste += amount;
        }
        return amount;
    }

    @Override
    public long extractFuel(long amount, boolean simulated) {
        amount = Math.min(this.fuel, amount);
        if (!simulated) {
            this.fuel -= amount;
        }
        return amount;
    }

    @Override
    public long extractWaste(long amount, boolean simulated) {
        amount = Math.min(this.waste, amount);
        if (!simulated) {
            this.waste -= amount;
        }
        return amount;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a("capacity", this.capacity);
        nbt.func_74772_a("fuel", this.fuel);
        nbt.func_74772_a("waste", this.waste);
        nbt.func_74780_a("partialUsed", this.partialUsed);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.capacity = nbt.func_74763_f("capacity");
        this.fuel = nbt.func_74763_f("fuel");
        this.waste = nbt.func_74763_f("waste");
        this.partialUsed = nbt.func_74769_h("partialUsed");
    }
}

