/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.classic;

import net.minecraft.nbt.CompoundNBT;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorBattery;

public class Battery
implements IReactorBattery {
    private double partialStored = 0.0;
    private long storedPower = 0L;
    private long maxStoredPower = 0L;

    void setMaxStoredPower(long maxStoredPower) {
        this.maxStoredPower = maxStoredPower;
    }

    long addPower(double powerProduced) {
        if (Double.isInfinite(powerProduced) || Double.isNaN(powerProduced)) {
            return 0L;
        }
        this.partialStored += powerProduced;
        if (this.partialStored < 1.0) {
            return 0L;
        }
        long toAdd = (long)this.partialStored;
        this.partialStored -= (double)toAdd;
        this.storedPower += toAdd;
        if (this.storedPower > this.maxStoredPower) {
            this.storedPower = this.maxStoredPower;
        }
        return toAdd;
    }

    @Override
    public long extract(long toExtract) {
        this.storedPower -= toExtract;
        return toExtract;
    }

    @Override
    public long stored() {
        return this.storedPower;
    }

    @Override
    public long capacity() {
        return this.maxStoredPower;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a("storedPower", this.storedPower);
        nbt.func_74772_a("maxStoredPower", this.maxStoredPower);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.storedPower = nbt.func_74763_f("storedPower");
        this.maxStoredPower = nbt.func_74763_f("maxStoredPower");
    }
}

