/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.client.CommonRender;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.CommonReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.PassiveReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorActivity;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorState;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorType;
import net.roguelogix.phosphophyllite.gui.client.RenderHelper;
import net.roguelogix.phosphophyllite.gui.client.ScreenBase;
import net.roguelogix.phosphophyllite.gui.client.elements.AbstractElement;
import net.roguelogix.phosphophyllite.gui.client.elements.Symbol;
import net.roguelogix.phosphophyllite.gui.client.elements.Tooltip;

@OnlyIn(value=Dist.CLIENT)
public class ActiveReactorTerminalScreen
extends ScreenBase<ReactorTerminalContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/reactor_terminal_active.png");
    private ReactorState reactorState;
    private final int screenWorkTimeTotal = 400;
    private int screenWorkTime = 0;
    private Fluid coolantFluid = Fluids.field_204541_a;
    private Fluid exhaustFluid = Fluids.field_204541_a;

    public ActiveReactorTerminalScreen(ReactorTerminalContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title, DEFAULT_TEXTURE, 198, 152);
        this.reactorState = (ReactorState)((ReactorTerminalContainer)this.func_212873_a_()).getGuiPacket();
        this.coolantFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.reactorState.coolantResourceLocation));
        this.exhaustFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.reactorState.exhaustResourceLocation));
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        CommonReactorTerminalScreen.initTooltips(this, this.reactorState);
        this.initTooltips();
        CommonReactorTerminalScreen.initControls(this, this.reactorState);
        CommonReactorTerminalScreen.initGauges(this, this.reactorState);
        this.initGauges();
        CommonReactorTerminalScreen.initSymbols(this, this.reactorState);
        this.initSymbols();
    }

    private void initTooltips() {
        Tooltip generationRateReadoutTooltip = new Tooltip((ScreenBase)this, 26, 38, 53, 16, StringTextComponent.field_240750_d_);
        generationRateReadoutTooltip.onTick = () -> {
            generationRateReadoutTooltip.tooltip = new StringTextComponent(String.format("%.3f mB/t", this.reactorState.reactorOutputRate));
        };
        this.addElement((AbstractElement)generationRateReadoutTooltip);
    }

    private void initGauges() {
        Symbol coolantIntakeTank = new Symbol((ScreenBase)this, 151, 25, 18, 64, 0, 152, StringTextComponent.field_240750_d_);
        coolantIntakeTank.onRender = (mS, mX, mY) -> CommonRender.renderFluidGauge(mS, coolantIntakeTank, this.reactorState.coolantStored, this.reactorState.coolantCapacity, this.coolantFluid);
        this.addElement((AbstractElement)coolantIntakeTank);
        Symbol hotExhaustTank = new Symbol((ScreenBase)this, 173, 25, 18, 64, 0, 152, StringTextComponent.field_240750_d_);
        hotExhaustTank.onRender = (mS, mX, mY) -> CommonRender.renderFluidGauge(mS, hotExhaustTank, this.reactorState.exhaustStored, this.reactorState.exhaustCapacity, this.exhaustFluid);
        this.addElement((AbstractElement)hotExhaustTank);
        Symbol progressBar = new Symbol((ScreenBase)this, 173, 90, 18, 26, 90, 152, null);
        progressBar.onRender = (mS, mX, mY) -> {
            if (this.reactorState.coolantStored > 0L) {
                ActiveReactorTerminalScreen.renderProgressBar(mS, (Symbol<ReactorTerminalContainer>)progressBar, this.reactorState.reactorActivity, this.screenWorkTime++, 400, this.coolantFluid);
                if (this.screenWorkTime >= 400) {
                    this.screenWorkTime = 0;
                }
            }
        };
        this.addElement((AbstractElement)progressBar);
    }

    private void initSymbols() {
        Symbol coolantIntakeTankSymbol = new Symbol((ScreenBase)this, 152, 6, 16, 16, 174, 152, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.coolant_intake_tank.tooltip"));
        coolantIntakeTankSymbol.onRender = (mS, mX, mY) -> RenderHelper.drawMaskedFluid((MatrixStack)mS, (int)coolantIntakeTankSymbol.x, (int)coolantIntakeTankSymbol.y, (int)this.func_230927_p_(), (int)coolantIntakeTankSymbol.width, (int)coolantIntakeTankSymbol.height, (int)coolantIntakeTankSymbol.u, (int)coolantIntakeTankSymbol.v, (Fluid)this.coolantFluid);
        this.addElement((AbstractElement)coolantIntakeTankSymbol);
        Symbol hotExhaustTankSymbol = new Symbol((ScreenBase)this, 174, 6, 16, 16, 158, 152, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.exhaust_tank.tooltip"));
        hotExhaustTankSymbol.onRender = (mS, mX, mY) -> RenderHelper.drawMaskedFluid((MatrixStack)mS, (int)hotExhaustTankSymbol.x, (int)hotExhaustTankSymbol.y, (int)this.func_230927_p_(), (int)hotExhaustTankSymbol.width, (int)hotExhaustTankSymbol.height, (int)hotExhaustTankSymbol.u, (int)hotExhaustTankSymbol.v, (Fluid)this.exhaustFluid);
        this.addElement((AbstractElement)hotExhaustTankSymbol);
        Symbol exhaustGenerationRateSymbol = new Symbol((ScreenBase)this, 8, 38, 16, 16, 142, 152, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.exhaust_generation_rate.tooltip"));
        exhaustGenerationRateSymbol.onRender = (mS, mX, mY) -> RenderHelper.drawMaskedFluid((MatrixStack)mS, (int)exhaustGenerationRateSymbol.x, (int)exhaustGenerationRateSymbol.y, (int)this.func_230927_p_(), (int)exhaustGenerationRateSymbol.width, (int)exhaustGenerationRateSymbol.height, (int)exhaustGenerationRateSymbol.u, (int)exhaustGenerationRateSymbol.v, (Fluid)this.exhaustFluid);
        this.addElement((AbstractElement)exhaustGenerationRateSymbol);
    }

    public void func_231023_e_() {
        this.reactorState = (ReactorState)((ReactorTerminalContainer)this.func_212873_a_()).getGuiPacket();
        super.func_231023_e_();
        if (this.reactorState.reactorType != ReactorType.ACTIVE) {
            this.getMinecraft().func_147108_a((Screen)new PassiveReactorTerminalScreen((ReactorTerminalContainer)this.field_147002_h, this.field_213127_e, this.field_230704_d_));
        }
        if (!this.reactorState.coolantResourceLocation.equals(Objects.requireNonNull(this.coolantFluid.getRegistryName()).toString())) {
            this.coolantFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.reactorState.coolantResourceLocation));
        }
        if (!this.reactorState.exhaustResourceLocation.equals(Objects.requireNonNull(this.exhaustFluid.getRegistryName()).toString())) {
            this.exhaustFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.reactorState.exhaustResourceLocation));
        }
    }

    public void func_230430_a_(@Nonnull MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        CommonReactorTerminalScreen.renderStatusText(mStack, this, this.reactorState.reactorActivity, this.reactorState.doAutoEject, this.reactorState.fuelHeatStored, this.reactorState.fuelUsageRate, this.reactorState.reactivityRate);
        this.getFont().func_238421_b_(mStack, RenderHelper.formatValue((double)(this.reactorState.reactorOutputRate / 1000.0), (String)"B/t"), (float)(this.getGuiLeft() + 27), (float)(this.getGuiTop() + 42), 0x404040);
    }

    private static void renderProgressBar(@Nonnull MatrixStack mStack, @Nonnull Symbol<ReactorTerminalContainer> symbol, ReactorActivity reactorActivity, int workTime, int workTimeTotal, Fluid coolant) {
        if (reactorActivity != ReactorActivity.ACTIVE) {
            workTime = 0;
        }
        if (workTime > 0 && workTimeTotal > 0) {
            int renderSize = symbol.height * workTime / workTimeTotal;
            symbol.blit(mStack, symbol.u + 18, symbol.v);
            symbol.blit(mStack, symbol.width, symbol.height - renderSize, symbol.u, symbol.v);
        }
        RenderHelper.drawMaskedFluid((MatrixStack)mStack, (int)(symbol.x + 1), (int)(symbol.y + 26), (int)0, (int)16, (int)16, (int)(symbol.u + 36), (int)symbol.v, (Fluid)coolant);
    }
}

