/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.NetworkHooks;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.HeatExchangerMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.blocks.HeatExchangerCoolantPortBlock;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.gui.container.HeatExchangerCoolantPortContainer;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.state.HeatExchangerCoolantPortState;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerBaseTile;
import net.roguelogix.phosphophyllite.fluids.FluidHandlerWrapper;
import net.roguelogix.phosphophyllite.fluids.IPhosphophylliteFluidHandler;
import net.roguelogix.phosphophyllite.fluids.MekanismGasWrappers;
import net.roguelogix.phosphophyllite.gui.client.api.IHasUpdatableState;
import net.roguelogix.phosphophyllite.multiblock.generic.IOnAssemblyTile;
import net.roguelogix.phosphophyllite.multiblock.generic.IOnDisassemblyTile;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockBlock;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.registry.TileSupplier;
import net.roguelogix.phosphophyllite.util.BlockStates;

@RegisterTileEntity(name="heat_exchanger_coolant_port")
public class HeatExchangerCoolantPortTile
extends HeatExchangerBaseTile
implements IPhosphophylliteFluidHandler,
IOnAssemblyTile,
IOnDisassemblyTile,
INamedContainerProvider,
IHasUpdatableState<HeatExchangerCoolantPortState> {
    public long lastCheckedTick;
    @RegisterTileEntity.Type
    public static TileEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final TileSupplier SUPPLIER;
    @CapabilityInject(value=IGasHandler.class)
    public static Capability<IGasHandler> GAS_HANDLER_CAPABILITY;
    private IPhosphophylliteFluidHandler HETank;
    private boolean inlet = true;
    private boolean condenser = true;
    private boolean connected = false;
    Direction outputDirection = null;
    LazyOptional<?> handlerOptional = LazyOptional.empty();
    IPhosphophylliteFluidHandler handler = null;
    FluidTank EMPTY_TANK = new FluidTank(0);
    private final HeatExchangerCoolantPortState state = new HeatExchangerCoolantPortState(this);

    public HeatExchangerCoolantPortTile() {
        super(TYPE);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandlerCapability().cast();
        }
        if (cap == GAS_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> MekanismGasWrappers.wrap((IPhosphophylliteFluidHandler)this)).cast();
        }
        return super.getCapability(cap, side);
    }

    public void setHETank(IPhosphophylliteFluidHandler HETank) {
        this.HETank = HETank;
    }

    public void setInlet(boolean inlet) {
        this.inlet = inlet;
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockStates.PORT_DIRECTION, (Comparable)Boolean.valueOf(inlet)));
        this.func_70296_d();
    }

    public void setInletOtherOutlet(boolean inlet) {
        ((HeatExchangerMultiblockController)this.controller).setInletPort(this, inlet);
    }

    public boolean isInlet() {
        return this.inlet;
    }

    public void setCondenser(boolean condenser) {
        this.condenser = condenser;
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)HeatExchangerCoolantPortBlock.CONDENSER, (Comparable)Boolean.valueOf(condenser)));
    }

    public boolean isCondenser() {
        return this.condenser;
    }

    public int tankCount() {
        if (this.HETank == null) {
            return 0;
        }
        return this.HETank.tankCount();
    }

    public long tankCapacity(int tank) {
        if (this.HETank == null) {
            return 0L;
        }
        return this.HETank.tankCapacity(tank);
    }

    @Nonnull
    public Fluid fluidTypeInTank(int tank) {
        if (this.HETank == null) {
            return Fluids.field_204541_a;
        }
        return this.HETank.fluidTypeInTank(tank);
    }

    @Nullable
    public CompoundNBT fluidTagInTank(int tank) {
        if (this.HETank == null) {
            return null;
        }
        return this.HETank.fluidTagInTank(tank);
    }

    public long fluidAmountInTank(int tank) {
        if (this.HETank == null) {
            return 0L;
        }
        return this.HETank.fluidAmountInTank(tank);
    }

    public boolean fluidValidForTank(int tank, @Nonnull Fluid fluid) {
        if (this.HETank == null) {
            return false;
        }
        return this.HETank.fluidValidForTank(tank, fluid);
    }

    public long fill(@Nonnull Fluid fluid, @Nullable CompoundNBT tag, long amount, boolean simulate) {
        if (this.HETank == null || !this.inlet) {
            return 0L;
        }
        return this.HETank.fill(fluid, null, amount, simulate);
    }

    public long drain(@Nonnull Fluid fluid, @Nullable CompoundNBT tag, long amount, boolean simulate) {
        if (this.HETank == null || this.inlet) {
            return 0L;
        }
        return this.HETank.drain(fluid, null, amount, simulate);
    }

    public long pushFluid() {
        if (!this.connected || this.inlet) {
            return 0L;
        }
        if (this.handlerOptional.isPresent()) {
            Fluid fluid = this.HETank.fluidTypeInTank(1);
            long amount = this.HETank.fluidAmountInTank(1);
            amount = this.HETank.drain(fluid, null, amount, true);
            amount = this.handler.fill(fluid, null, amount, false);
            amount = this.HETank.drain(fluid, null, amount, false);
            return amount;
        }
        this.handlerOptional = LazyOptional.empty();
        this.handler = null;
        this.connected = false;
        return 0L;
    }

    public void neighborChanged() {
        LazyOptional gasOptional;
        this.handlerOptional = LazyOptional.empty();
        this.handler = null;
        if (this.outputDirection == null) {
            this.connected = false;
            return;
        }
        assert (this.field_145850_b != null);
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.outputDirection));
        if (te == null) {
            this.connected = false;
            return;
        }
        this.connected = false;
        LazyOptional waterOutput = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.outputDirection.func_176734_d());
        if (waterOutput.isPresent()) {
            this.connected = true;
            this.handlerOptional = waterOutput;
            this.handler = FluidHandlerWrapper.wrap((IFluidHandler)((IFluidHandler)waterOutput.orElse((Object)this.EMPTY_TANK)));
        } else if (GAS_HANDLER_CAPABILITY != null && (gasOptional = te.getCapability(GAS_HANDLER_CAPABILITY, this.outputDirection.func_176734_d())).isPresent()) {
            IGasHandler gasHandler = (IGasHandler)gasOptional.orElse((Object)MekanismGasWrappers.EMPTY_TANK);
            this.connected = true;
            this.handlerOptional = gasOptional;
            this.handler = MekanismGasWrappers.wrap((IGasHandler)gasHandler);
        }
    }

    protected void readNBT(@Nonnull CompoundNBT compound) {
        super.readNBT(compound);
        this.inlet = compound.func_74767_n("inlet");
    }

    @Nonnull
    protected CompoundNBT writeNBT() {
        CompoundNBT nbt = super.writeNBT();
        nbt.func_74757_a("inlet", this.inlet);
        return nbt;
    }

    public void onAssembly() {
        this.outputDirection = (Direction)this.func_195044_w().func_177229_b((Property)BlockStates.FACING);
        this.neighborChanged();
    }

    public void onDisassembly() {
        this.outputDirection = null;
        this.HETank = null;
        this.neighborChanged();
    }

    @Nonnull
    public HeatExchangerCoolantPortState getState() {
        return this.state;
    }

    public void updateState() {
        this.state.direction = this.isInlet();
        this.state.condenser = this.isCondenser();
    }

    @Nonnull
    public ActionResultType onBlockActivated(@Nonnull PlayerEntity player, @Nonnull Hand handIn) {
        assert (this.field_145850_b != null);
        if (((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)MultiblockBlock.ASSEMBLED)).booleanValue()) {
            if (!this.field_145850_b.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.func_174877_v());
            }
            return ActionResultType.SUCCESS;
        }
        return super.onBlockActivated(player, handIn);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(HeatExchangerCoolantPortBlock.INSTANCE.func_149739_a());
    }

    @Nullable
    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
        return new HeatExchangerCoolantPortContainer(windowId, this.field_174879_c, player);
    }

    public void runRequest(String requestName, Object requestData) {
        if (requestName.equals("setDirection")) {
            int direction = (Integer)requestData;
            this.setInletOtherOutlet(direction == 0);
        }
    }

    static {
        SUPPLIER = HeatExchangerCoolantPortTile::new;
        GAS_HANDLER_CAPABILITY = null;
    }
}

