/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.heatexchanger;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.blocks.HeatExchangerBaseBlock;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.blocks.HeatExchangerCasingBlock;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerBaseTile;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerCondensorChannelTile;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerCoolantPortTile;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerEvaporatorChannelTile;
import net.roguelogix.biggerreactors.util.FluidTransitionTank;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.multiblock.generic.ConnectedTextureStates;
import net.roguelogix.phosphophyllite.multiblock.generic.ValidationError;
import net.roguelogix.phosphophyllite.multiblock.generic.Validator;
import net.roguelogix.phosphophyllite.multiblock.rectangular.RectangularMultiblockController;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.util.HeatBody;
import net.roguelogix.phosphophyllite.util.Util;

public class HeatExchangerMultiblockController
extends RectangularMultiblockController<HeatExchangerMultiblockController, HeatExchangerBaseTile, HeatExchangerBaseBlock> {
    public final Set<HeatExchangerCondensorChannelTile> condenserChannels = new LinkedHashSet<HeatExchangerCondensorChannelTile>();
    public final Set<HeatExchangerEvaporatorChannelTile> evaporatorChannels = new LinkedHashSet<HeatExchangerEvaporatorChannelTile>();
    private final Set<HeatExchangerCoolantPortTile> coolantPorts = new LinkedHashSet<HeatExchangerCoolantPortTile>();
    public final ReadWriteLock locks = new ReentrantReadWriteLock();
    public final FluidTransitionTank evaporatorTank = new FluidTransitionTank(false);
    public final FluidTransitionTank condenserTank = new FluidTransitionTank(true);
    public final HeatBody ambientHeatBody = new HeatBody();
    public final HeatBody airHeatBody = new HeatBody();
    public final HeatBody condenserHeatBody = new HeatBody();
    public final HeatBody evaporatorHeatBody = new HeatBody();
    public double channelRFKT;
    public double evaporatorAirRFKT;
    public double condenserAirRFKT;
    public double airAmbientRFKT;

    public HeatExchangerMultiblockController(@Nonnull World world) {
        super(world, tile -> tile instanceof HeatExchangerBaseTile, block -> block instanceof HeatExchangerBaseBlock);
        this.minSize.set(4, 3, 3);
        this.maxSize.set(-1, -1, -1);
        this.setAssemblyValidator(HeatExchangerMultiblockController::validate);
        this.frameValidator = block -> block instanceof HeatExchangerCasingBlock;
        this.exteriorValidator = Validator.or((Validator)this.frameValidator, block -> false);
        this.interiorValidator = block -> block instanceof AirBlock;
    }

    private boolean validate() {
        BlockPos channelPos;
        if (this.condenserChannels.isEmpty() || this.evaporatorChannels.isEmpty()) {
            throw new ValidationError((ITextComponent)new TranslationTextComponent("multiblock.error.biggerreactors.heat_exchanger.missing_channel_type"));
        }
        if (this.coolantPorts.size() != 4) {
            throw new ValidationError((ITextComponent)new TranslationTextComponent("multiblock.error.biggerreactors.heat_exchanger.invalid_port_count"));
        }
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        int condenserPorts = 0;
        int evaporatorPorts = 0;
        for (HeatExchangerCoolantPortTile coolantPort : this.coolantPorts) {
            BlockPos portPos = coolantPort.func_174877_v();
            boolean channelFound = false;
            for (Direction value : Direction.values()) {
                mutableBlockPos.func_189533_g((net.minecraft.util.math.vector.Vector3i)portPos);
                mutableBlockPos.func_189536_c(value);
                TileEntity tile = this.blocks.getTile((BlockPos)mutableBlockPos);
                if (tile instanceof HeatExchangerEvaporatorChannelTile) {
                    ++evaporatorPorts;
                    channelFound = true;
                    break;
                }
                if (!(tile instanceof HeatExchangerCondensorChannelTile)) continue;
                ++condenserPorts;
                channelFound = true;
                break;
            }
            if (channelFound) continue;
            throw new ValidationError((ITextComponent)new TranslationTextComponent("multiblock.error.biggerreactors.heat_exchanger.coolant_port_unconnected", new Object[]{portPos.func_177958_n(), portPos.func_177956_o(), portPos.func_177952_p()}));
        }
        if (condenserPorts != 2 || evaporatorPorts != 2) {
            throw new ValidationError((ITextComponent)new TranslationTextComponent("multiblock.error.biggerreactors.heat_exchanger.duplicate_port_types"));
        }
        this.verifyFluidChannels(this.condenserChannels);
        this.verifyFluidChannels(this.evaporatorChannels);
        long tick = Phosphophyllite.tickNumber();
        block2: for (HeatExchangerCoolantPortTile coolantPort : this.coolantPorts) {
            if (coolantPort.lastCheckedTick == tick) continue;
            Direction nextDirection = null;
            for (Direction value : Direction.values()) {
                mutableBlockPos.func_189533_g((net.minecraft.util.math.vector.Vector3i)coolantPort.func_174877_v());
                mutableBlockPos.func_189536_c(value);
                HeatExchangerBaseTile tile = (HeatExchangerBaseTile)this.blocks.getTile((BlockPos)mutableBlockPos);
                if (!(tile instanceof HeatExchangerCondensorChannelTile) && !(tile instanceof HeatExchangerEvaporatorChannelTile)) continue;
                nextDirection = value;
                break;
            }
            mutableBlockPos.func_189533_g((net.minecraft.util.math.vector.Vector3i)coolantPort.func_174877_v());
            if (nextDirection == null) {
                throw new ValidationError("Unknown channel verification error, this shouldn't be possible " + mutableBlockPos);
            }
            while (true) {
                mutableBlockPos.func_189536_c(nextDirection);
                HeatExchangerBaseTile channelTile = (HeatExchangerBaseTile)this.blocks.getTile((BlockPos)mutableBlockPos);
                if (channelTile instanceof HeatExchangerCoolantPortTile) continue block2;
                if (!(channelTile instanceof HeatExchangerCondensorChannelTile) && !(channelTile instanceof HeatExchangerEvaporatorChannelTile)) {
                    throw new ValidationError("Unknown channel verification error, this shouldn't be possible " + mutableBlockPos);
                }
                if (channelTile instanceof HeatExchangerCondensorChannelTile) {
                    ((HeatExchangerCondensorChannelTile)channelTile).lastCheckedTick = tick;
                }
                if (channelTile instanceof HeatExchangerEvaporatorChannelTile) {
                    ((HeatExchangerEvaporatorChannelTile)channelTile).lastCheckedTick = tick;
                }
                BlockState channelState = channelTile.func_195044_w();
                if (nextDirection != Direction.DOWN && ((Boolean)channelState.func_177229_b((Property)ConnectedTextureStates.TOP_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.UP;
                    continue;
                }
                if (nextDirection != Direction.UP && ((Boolean)channelState.func_177229_b((Property)ConnectedTextureStates.BOTTOM_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.DOWN;
                    continue;
                }
                if (nextDirection != Direction.SOUTH && ((Boolean)channelState.func_177229_b((Property)ConnectedTextureStates.NORTH_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.NORTH;
                    continue;
                }
                if (nextDirection != Direction.NORTH && ((Boolean)channelState.func_177229_b((Property)ConnectedTextureStates.SOUTH_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.SOUTH;
                    continue;
                }
                if (nextDirection != Direction.WEST && ((Boolean)channelState.func_177229_b((Property)ConnectedTextureStates.EAST_CONNECTED_PROPERTY)).booleanValue()) {
                    nextDirection = Direction.EAST;
                    continue;
                }
                if (nextDirection == Direction.EAST || !((Boolean)channelState.func_177229_b((Property)ConnectedTextureStates.WEST_CONNECTED_PROPERTY)).booleanValue()) break;
                nextDirection = Direction.WEST;
            }
            throw new ValidationError("Unknown channel verification error, this shouldn't be possible " + mutableBlockPos);
        }
        for (HeatExchangerCondensorChannelTile condenserChannel : this.condenserChannels) {
            if (condenserChannel.lastCheckedTick == tick) continue;
            channelPos = condenserChannel.func_174877_v();
            throw new ValidationError((ITextComponent)new TranslationTextComponent("multiblock.error.biggerreactors.heat_exchanger.dangling_channel", new Object[]{channelPos.func_177958_n(), channelPos.func_177956_o(), channelPos.func_177952_p()}));
        }
        for (HeatExchangerEvaporatorChannelTile evaporatorChannel : this.evaporatorChannels) {
            if (evaporatorChannel.lastCheckedTick == tick) continue;
            channelPos = evaporatorChannel.func_174877_v();
            throw new ValidationError((ITextComponent)new TranslationTextComponent("multiblock.error.biggerreactors.heat_exchanger.dangling_channel", new Object[]{channelPos.func_177958_n(), channelPos.func_177956_o(), channelPos.func_177952_p()}));
        }
        Util.chunkCachedBlockStateIteration((Vector3ic)this.minCoord(), (Vector3ic)this.maxCoord(), (World)this.world, (block, pos) -> {
            if (block.func_177230_c() instanceof HeatExchangerBaseBlock) {
                mutableBlockPos.func_181079_c(pos.x, pos.y, pos.z);
                if (!this.blocks.containsPos((BlockPos)mutableBlockPos)) {
                    throw new ValidationError((ITextComponent)new TranslationTextComponent("multiblock.error.biggerreactors.heat_exchanger.dangling_internal_part", new Object[]{pos.x, pos.y, pos.z}));
                }
            }
        });
        return true;
    }

    private void verifyFluidChannels(Set<? extends HeatExchangerBaseTile> channels) {
        channels.forEach(tile -> {
            BlockState state = tile.func_195044_w();
            int connectedSides = 0;
            connectedSides += (Boolean)state.func_177229_b((Property)ConnectedTextureStates.TOP_CONNECTED_PROPERTY) != false ? 1 : 0;
            connectedSides += (Boolean)state.func_177229_b((Property)ConnectedTextureStates.BOTTOM_CONNECTED_PROPERTY) != false ? 1 : 0;
            connectedSides += (Boolean)state.func_177229_b((Property)ConnectedTextureStates.NORTH_CONNECTED_PROPERTY) != false ? 1 : 0;
            connectedSides += (Boolean)state.func_177229_b((Property)ConnectedTextureStates.SOUTH_CONNECTED_PROPERTY) != false ? 1 : 0;
            connectedSides += (Boolean)state.func_177229_b((Property)ConnectedTextureStates.EAST_CONNECTED_PROPERTY) != false ? 1 : 0;
            if ((connectedSides += (Boolean)state.func_177229_b((Property)ConnectedTextureStates.WEST_CONNECTED_PROPERTY) != false ? 1 : 0) != 2) {
                throw new ValidationError("all fluid channels must have exactly two connections " + tile.func_174877_v());
            }
        });
    }

    protected void onPartPlaced(@Nonnull HeatExchangerBaseTile placed) {
        this.onPartAttached(placed);
    }

    protected void onPartAttached(@Nonnull HeatExchangerBaseTile toAttach) {
        if (toAttach instanceof HeatExchangerCondensorChannelTile) {
            this.condenserChannels.add((HeatExchangerCondensorChannelTile)toAttach);
        }
        if (toAttach instanceof HeatExchangerEvaporatorChannelTile) {
            this.evaporatorChannels.add((HeatExchangerEvaporatorChannelTile)toAttach);
        }
        if (toAttach instanceof HeatExchangerCoolantPortTile) {
            this.coolantPorts.add((HeatExchangerCoolantPortTile)toAttach);
        }
    }

    protected void onPartBroken(@Nonnull HeatExchangerBaseTile broken) {
        this.onPartDetached(broken);
    }

    protected void onPartDetached(@Nonnull HeatExchangerBaseTile toDetach) {
        if (toDetach instanceof HeatExchangerCondensorChannelTile) {
            this.condenserChannels.remove((Object)toDetach);
        }
        if (toDetach instanceof HeatExchangerEvaporatorChannelTile) {
            this.evaporatorChannels.remove((Object)toDetach);
        }
        if (toDetach instanceof HeatExchangerCoolantPortTile) {
            this.coolantPorts.remove((Object)toDetach);
        }
    }

    protected void onAssembled() {
        this.onUnpaused();
        double ambientTemperature = this.world.func_230315_m_().func_236040_e_() ? 423.15 : 293.15;
        this.ambientHeatBody.setTemperature(ambientTemperature);
        this.airHeatBody.setTemperature(ambientTemperature);
        this.condenserHeatBody.setTemperature(ambientTemperature);
        this.evaporatorHeatBody.setTemperature(ambientTemperature);
    }

    protected void onUnpaused() {
        HeatExchangerBaseTile tile;
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        this.condenserHeatBody.setRfPerKelvin((double)this.condenserChannels.size() * Config.HeatExchanger.ChannelFEPerKelvinUnitVolume);
        this.evaporatorHeatBody.setRfPerKelvin((double)this.evaporatorChannels.size() * Config.HeatExchanger.ChannelFEPerKelvinUnitVolume);
        this.condenserTank.perSideCapacity = (long)this.condenserChannels.size() * Config.HeatExchanger.ChannelTankVolumePerBlock;
        this.evaporatorTank.perSideCapacity = (long)this.evaporatorChannels.size() * Config.HeatExchanger.ChannelTankVolumePerBlock;
        Vector3i vec = new Vector3i(this.maxCoord()).sub(this.minCoord()).add(1, 1, 1);
        int airVolume = vec.x * vec.y * vec.z;
        airVolume -= this.condenserChannels.size();
        this.airHeatBody.setRfPerKelvin((double)(airVolume -= this.evaporatorChannels.size()) * Config.HeatExchanger.AirFEPerKelvinUnitVolume);
        int channelContactArea = 0;
        int evaporatorAirContactArea = 0;
        int condenserAirContactArea = 0;
        int airAmbientContactArea = 0;
        for (HeatExchangerCondensorChannelTile heatExchangerCondensorChannelTile : this.condenserChannels) {
            for (Direction value : Direction.values()) {
                mutableBlockPos.func_189533_g((net.minecraft.util.math.vector.Vector3i)heatExchangerCondensorChannelTile.func_174877_v());
                mutableBlockPos.func_189536_c(value);
                tile = (HeatExchangerBaseTile)this.blocks.getTile((BlockPos)mutableBlockPos);
                if (tile instanceof HeatExchangerEvaporatorChannelTile) {
                    ++channelContactArea;
                    continue;
                }
                if (tile instanceof HeatExchangerCondensorChannelTile) continue;
                ++condenserAirContactArea;
            }
        }
        for (HeatExchangerEvaporatorChannelTile heatExchangerEvaporatorChannelTile : this.evaporatorChannels) {
            for (Direction value : Direction.values()) {
                mutableBlockPos.func_189533_g((net.minecraft.util.math.vector.Vector3i)heatExchangerEvaporatorChannelTile.func_174877_v());
                mutableBlockPos.func_189536_c(value);
                tile = (HeatExchangerBaseTile)this.blocks.getTile((BlockPos)mutableBlockPos);
                if (tile instanceof HeatExchangerCondensorChannelTile || tile instanceof HeatExchangerEvaporatorChannelTile) continue;
                ++evaporatorAirContactArea;
            }
        }
        airAmbientContactArea = vec.x * vec.y + vec.x * vec.z + vec.y * vec.z;
        this.channelRFKT = (double)channelContactArea * Config.HeatExchanger.ChannelFEPerKelvinMetreSquared;
        this.condenserAirRFKT = (double)condenserAirContactArea * Config.HeatExchanger.AirFEPerKelvinMetreSquared;
        this.evaporatorAirRFKT = (double)evaporatorAirContactArea * Config.HeatExchanger.AirFEPerKelvinMetreSquared;
        this.airAmbientRFKT = (double)(airAmbientContactArea *= 2) * Config.HeatExchanger.AmbientFEPerKelvinMetreSquared;
        block4: for (HeatExchangerCoolantPortTile heatExchangerCoolantPortTile : this.coolantPorts) {
            BlockPos portPos = heatExchangerCoolantPortTile.func_174877_v();
            for (Direction value : Direction.values()) {
                mutableBlockPos.func_189533_g((net.minecraft.util.math.vector.Vector3i)portPos);
                mutableBlockPos.func_189536_c(value);
                TileEntity tile2 = this.blocks.getTile((BlockPos)mutableBlockPos);
                if (tile2 instanceof HeatExchangerEvaporatorChannelTile) {
                    heatExchangerCoolantPortTile.setHETank(this.evaporatorTank);
                    heatExchangerCoolantPortTile.setCondenser(false);
                    continue block4;
                }
                if (!(tile2 instanceof HeatExchangerCondensorChannelTile)) continue;
                heatExchangerCoolantPortTile.setHETank(this.condenserTank);
                heatExchangerCoolantPortTile.setCondenser(true);
                continue block4;
            }
        }
        for (HeatExchangerCoolantPortTile heatExchangerCoolantPortTile : this.coolantPorts) {
            for (HeatExchangerCoolantPortTile port : this.coolantPorts) {
                if (port.isCondenser() != heatExchangerCoolantPortTile.isCondenser() || port == heatExchangerCoolantPortTile) continue;
                port.setInlet(!heatExchangerCoolantPortTile.isInlet());
            }
        }
        this.ambientHeatBody.setInfinite(true);
    }

    public void tick() {
        this.condenserTank.transferWith(this.condenserHeatBody, (double)this.condenserChannels.size() * Config.HeatExchanger.ChannelInternalSurfaceArea);
        this.condenserHeatBody.transferWith(this.airHeatBody, this.condenserAirRFKT);
        this.condenserHeatBody.transferWith(this.evaporatorHeatBody, this.channelRFKT);
        this.evaporatorHeatBody.transferWith(this.airHeatBody, this.evaporatorAirRFKT);
        this.evaporatorTank.transferWith(this.evaporatorHeatBody, (double)this.evaporatorChannels.size() * Config.HeatExchanger.ChannelInternalSurfaceArea);
        this.airHeatBody.transferWith(this.ambientHeatBody, this.airAmbientRFKT);
        this.coolantPorts.forEach(HeatExchangerCoolantPortTile::pushFluid);
    }

    protected void read(@Nonnull CompoundNBT nbt) {
        super.read(nbt);
        this.condenserTank.deserializeNBT(nbt.func_74775_l("condenserTank"));
        this.evaporatorTank.deserializeNBT(nbt.func_74775_l("evaporatorTank"));
        this.ambientHeatBody.setTemperature(nbt.func_74769_h("ambientHeatBody"));
        this.airHeatBody.setTemperature(nbt.func_74769_h("airHeatBody"));
        this.condenserHeatBody.setTemperature(nbt.func_74769_h("condenserHeatBody"));
        this.evaporatorHeatBody.setTemperature(nbt.func_74769_h("evaporatorHeatBody"));
        this.channelRFKT = nbt.func_74769_h("channelRFKT");
        this.evaporatorAirRFKT = nbt.func_74769_h("evaporatorAirRFKT");
        this.condenserAirRFKT = nbt.func_74769_h("condenserAirRFKT");
        this.airAmbientRFKT = nbt.func_74769_h("airAmbientRFKT");
    }

    @Nonnull
    protected CompoundNBT write() {
        CompoundNBT nbt = super.write();
        nbt.func_218657_a("condenserTank", (INBT)this.condenserTank.serializeNBT());
        nbt.func_218657_a("evaporatorTank", (INBT)this.evaporatorTank.serializeNBT());
        nbt.func_74780_a("ambientHeatBody", this.ambientHeatBody.temperature());
        nbt.func_74780_a("airHeatBody", this.airHeatBody.temperature());
        nbt.func_74780_a("condenserHeatBody", this.condenserHeatBody.temperature());
        nbt.func_74780_a("evaporatorHeatBody", this.evaporatorHeatBody.temperature());
        nbt.func_74780_a("channelRFKT", this.channelRFKT);
        nbt.func_74780_a("evaporatorAirRFKT", this.evaporatorAirRFKT);
        nbt.func_74780_a("condenserAirRFKT", this.condenserAirRFKT);
        nbt.func_74780_a("airAmbientRFKT", this.airAmbientRFKT);
        return nbt;
    }

    public void setInletPort(HeatExchangerCoolantPortTile port, boolean inlet) {
        port.setInlet(inlet);
        for (HeatExchangerCoolantPortTile coolantPort : this.coolantPorts) {
            if (coolantPort == port || coolantPort.isCondenser() != port.isCondenser()) continue;
            coolantPort.setInlet(!inlet);
        }
    }
}

