/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class ChippedRecipe
implements IRecipe<IInventory> {
    private final Serializer serializer;
    private final ResourceLocation id;
    private final String group;
    private final List<ITag<Item>> tags;
    private final Block icon;

    public ChippedRecipe(Serializer serializer, ResourceLocation id, String group, List<ITag<Item>> tags, Block block) {
        this.serializer = serializer;
        this.id = id;
        this.group = group;
        this.tags = tags;
        this.icon = block;
    }

    public boolean func_77569_a(IInventory inventory, @NotNull World world) {
        ItemStack item = inventory.func_70301_a(0);
        if (!item.func_190926_b()) {
            for (ITag<Item> tag : this.tags) {
                if (!item.func_77973_b().func_206844_a(tag)) continue;
                return true;
            }
        }
        return false;
    }

    public List<ITag<Item>> getTags() {
        return this.tags;
    }

    public Stream<ItemStack> getResults(IInventory container) {
        ItemStack current = container.func_70301_a(0);
        if (!current.func_190926_b()) {
            Item item = current.func_77973_b();
            return this.tags.stream().filter(arg_0 -> ((Item)item).func_206844_a(arg_0)).flatMap(tag -> tag.func_230236_b_().stream()).filter(value -> value != item).map(ItemStack::new);
        }
        return Stream.empty();
    }

    @NotNull
    public ItemStack func_77572_b(@NotNull IInventory inventory) {
        return this.func_77571_b();
    }

    public boolean func_194133_a(int i, int j) {
        return true;
    }

    @NotNull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    @NotNull
    public String func_193358_e() {
        return this.group;
    }

    @NotNull
    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)this.icon);
    }

    @NotNull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @NotNull
    public IRecipeSerializer<?> func_199559_b() {
        return this.serializer;
    }

    @NotNull
    public IRecipeType<?> func_222127_g() {
        return this.serializer.getType();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ChippedRecipe> {
        private final IRecipeType<?> type;
        private final Block icon;

        public Serializer(IRecipeType<?> type, Block icon) {
            this.type = type;
            this.icon = icon;
        }

        @NotNull
        public ChippedRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            ArrayList<ITag<Item>> tags = new ArrayList<ITag<Item>>();
            JsonArray tagArray = JSONUtils.func_151214_t((JsonObject)json, (String)"tags");
            for (int i = 0; i < tagArray.size(); ++i) {
                String tagName = JSONUtils.func_151206_a((JsonElement)tagArray.get(i), (String)("tags[" + i + "]"));
                ResourceLocation id = new ResourceLocation(tagName);
                ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(id);
                if (tag == null) {
                    throw new JsonSyntaxException("Unknown item tag '" + id + "'");
                }
                tags.add((ITag<Item>)tag);
            }
            return new ChippedRecipe(this, recipeId, s, tags, this.icon);
        }

        public ChippedRecipe fromNetwork(@NotNull ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            int tagCount = buffer.func_150792_a();
            ArrayList<ITag<Item>> tags = new ArrayList<ITag<Item>>(tagCount);
            for (int i = 0; i < tagCount; ++i) {
                int itemCount = buffer.func_150792_a();
                LinkedHashSet<Item> items = new LinkedHashSet<Item>(itemCount);
                for (int j = 0; j < itemCount; ++j) {
                    items.add(Item.func_150899_d((int)buffer.func_150792_a()));
                }
                tags.add((ITag<Item>)ITag.func_232946_a_(items));
            }
            return new ChippedRecipe(this, recipeId, s, tags, this.icon);
        }

        public void toNetwork(PacketBuffer buffer, @NotNull ChippedRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            buffer.func_150787_b(recipe.tags.size());
            for (ITag tag : recipe.tags) {
                List values = tag.func_230236_b_();
                buffer.func_150787_b(values.size());
                for (Item item : values) {
                    buffer.func_150787_b(Item.func_150891_b((Item)item));
                }
            }
        }

        public IRecipeType<?> getType() {
            return this.type;
        }
    }
}

