/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped.data.client;

import com.grimbo.chipped.Chipped;
import com.grimbo.chipped.api.ChippedBlockType;
import com.grimbo.chipped.api.ChippedWoodType;
import com.grimbo.chipped.block.ChippedBlockTypes;
import com.grimbo.chipped.block.ChippedBlocks;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.MelonBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.PumpkinBlock;
import net.minecraft.block.RedstoneLampBlock;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.RedstoneWallTorchBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.StainedGlassPaneBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.DyeColor;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class ChippedBlockStateProvider
extends BlockStateProvider {
    public ChippedBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "chipped", exFileHelper);
    }

    /*
     * WARNING - void declaration
     */
    protected void registerStatesAndModels() {
        int i;
        void var4_54;
        void var2_10;
        for (ChippedBlockType<Block> chippedBlockType : ChippedBlocks.stones18) {
            this.createCubeFromList((ChippedBlockType<?>)chippedBlockType);
        }
        this.createCubeFromList(ChippedBlockTypes.STONE, ChippedBlockTypes.COBBLESTONE, ChippedBlockTypes.END_STONE, ChippedBlockTypes.NETHERRACK, ChippedBlockTypes.GILDED_BLACKSTONES, ChippedBlockTypes.BLACKSTONES, ChippedBlockTypes.BASALTS, ChippedBlockTypes.OBSIDIAN, ChippedBlockTypes.CRYING_OBSIDIAN, ChippedBlockTypes.CLAYS, ChippedBlockTypes.GLASSES, ChippedBlockTypes.GLOWSTONES, ChippedBlockTypes.SEA_LANTERNS, ChippedBlockTypes.SHROOMLIGHTS, ChippedBlockTypes.BROWN_MUSHROOM_BLOCK, ChippedBlockTypes.RED_MUSHROOM_BLOCK, ChippedBlockTypes.WARPED_WART_BLOCK, ChippedBlockTypes.NETHER_WART_BLOCK, ChippedBlockTypes.SOUL_SANDS);
        this.registerGlassPanes(ChippedBlockTypes.GLASS_PANES, "glass", "glass_pane_1_top", 1, 6);
        this.registerGlassPanes(ChippedBlockTypes.GLASS_PANES, "glass", "glass_pane_2_top", 7, 14);
        for (int id = 0; id < 16; ++id) {
            void var4_22;
            DyeColor dyeColor = DyeColor.func_196056_a((int)id);
            this.createCubeFromList((ChippedBlockType<?>)ChippedBlockTypes.TERRACOTTAS.get(dyeColor));
            this.createCubeFromList((ChippedBlockType<?>)ChippedBlockTypes.CONCRETES.get(dyeColor));
            this.createCubeFromList((ChippedBlockType<?>)ChippedBlockTypes.WOOL.get(dyeColor));
            this.createCubeFromList((ChippedBlockType<?>)ChippedBlockTypes.STAINED_GLASSES.get(dyeColor));
            List<RegistryObject<CarpetBlock>> blocks = ChippedBlockTypes.CARPETS.get(dyeColor).getBlocks();
            boolean bl = false;
            while (var4_22 < blocks.size()) {
                void n = var4_22 + true;
                this.simpleBlock((Block)blocks.get((int)var4_22).get(), (ModelFile)this.models().carpet(dyeColor + "_carpet_" + (int)n, this.modLoc("block/" + dyeColor + "_wool/" + dyeColor + "_wool_" + (int)n)));
                ++var4_22;
            }
            ChippedBlockType<StainedGlassPaneBlock> chippedBlockType = ChippedBlockTypes.STAINED_GLASS_PANES.get(dyeColor);
            this.registerGlassPanes(chippedBlockType, dyeColor + "_stained_glass", "glass_pane_2_top", 1, chippedBlockType.getBlocks().size());
        }
        for (ChippedWoodType chippedWoodType : ChippedWoodType.VALUES) {
            this.createCubeFromList((ChippedBlockType<?>)ChippedBlockTypes.PLANKS.get((Object)chippedWoodType));
            this.registerGlassPanes(ChippedBlockTypes.GLASS_PANES, (Object)((Object)chippedWoodType) + "_wood_glass_pane", (Object)((Object)chippedWoodType) + "_wood_glass", "glass", (Object)((Object)chippedWoodType) + "_wood_glass_pane_top", 1, 6);
        }
        for (RegistryObject registryObject : ChippedBlockTypes.HAY_BLOCKS.getBlocks()) {
            String name2 = registryObject.getId().func_110623_a();
            this.axisBlock((RotatedPillarBlock)registryObject.get(), this.modLoc("block/" + ChippedBlockTypes.HAY_BLOCKS + "/" + name2));
        }
        List<RegistryObject<Block>> dried_kelp_blocks = ChippedBlockTypes.DRIED_KELP_BLOCKS.getBlocks();
        boolean bl = true;
        while (var2_10 <= 12) {
            if (var2_10 != 5) {
                RegistryObject<Block> block3 = dried_kelp_blocks.get((int)(var2_10 - true));
                String string = block3.getId().func_110623_a();
                if (var2_10 == 12) {
                    this.simpleBlock((Block)block3.get(), (ModelFile)this.models().cubeAll(string, this.modLoc("block/" + ChippedBlockTypes.DRIED_KELP_BLOCKS + "/" + string)));
                } else {
                    this.simpleBlock((Block)block3.get(), (ModelFile)this.models().cubeBottomTop(string, this.modLoc("block/" + ChippedBlockTypes.DRIED_KELP_BLOCKS + "/" + string + "_side"), this.modLoc("block/" + ChippedBlockTypes.DRIED_KELP_BLOCKS + "/" + string + "_top"), this.modLoc("block/" + ChippedBlockTypes.DRIED_KELP_BLOCKS + "/" + string + "_top")));
                }
            }
            ++var2_10;
        }
        for (RegistryObject<MelonBlock> block4 : ChippedBlockTypes.MELONS.getBlocks()) {
            String string = block4.getId().func_110623_a();
            this.simpleBlock((Block)block4.get(), (ModelFile)this.models().cubeColumn(string, this.modLoc("block/" + ChippedBlockTypes.MELONS + "/" + string + "_side"), this.modLoc("block/" + ChippedBlockTypes.MELONS + "/" + string + "_top")));
        }
        List<RegistryObject<PumpkinBlock>> list = ChippedBlockTypes.PUMPKINS.getBlocks();
        for (int i2 = 1; i2 <= ChippedBlocks.specialPumpkinList.length; ++i2) {
            RegistryObject<PumpkinBlock> registryObject = list.get(i2 - 1);
            String name3 = registryObject.getId().func_110623_a();
            this.simpleBlock((Block)registryObject.get(), (ModelFile)this.models().cubeColumn(name3, this.modLoc("block/" + ChippedBlockTypes.PUMPKINS + "/" + name3 + "_side"), this.modLoc("block/" + ChippedBlockTypes.PUMPKINS + "/" + name3 + "_top")));
        }
        for (int i2 = ChippedBlocks.specialPumpkinList.length + 1; i2 <= ChippedBlocks.specialPumpkinList.length + 3; ++i2) {
            RegistryObject<PumpkinBlock> registryObject = list.get(i2 - 1);
            String name4 = registryObject.getId().func_110623_a();
            this.simpleBlock((Block)registryObject.get(), (ModelFile)this.models().cubeBottomTop(name4, this.modLoc("block/" + ChippedBlockTypes.PUMPKINS + "/" + name4 + "_side"), this.modLoc("block/" + ChippedBlockTypes.PUMPKINS + "/" + name4 + "_bottom"), this.modLoc("block/" + ChippedBlockTypes.PUMPKINS + "/" + name4 + "_top")));
        }
        for (RegistryObject<MushroomBlock> registryObject : ChippedBlockTypes.BROWN_MUSHROOMS.getBlocks()) {
            String name5 = registryObject.getId().func_110623_a();
            this.simpleBlock((Block)registryObject.get(), (ModelFile)this.models().cross(name5, this.modLoc("block/" + ChippedBlockTypes.BROWN_MUSHROOMS + "/" + name5)));
        }
        for (RegistryObject<MushroomBlock> registryObject : ChippedBlockTypes.RED_MUSHROOMS.getBlocks()) {
            String name6 = registryObject.getId().func_110623_a();
            this.simpleBlock((Block)registryObject.get(), (ModelFile)this.models().cross(name6, this.modLoc("block/" + ChippedBlockTypes.RED_MUSHROOMS + "/" + name6)));
        }
        for (RegistryObject<MushroomBlock> registryObject : ChippedBlockTypes.WARPED_FUNGUS.getBlocks()) {
            String name7 = registryObject.getId().func_110623_a();
            this.simpleBlock((Block)registryObject.get(), (ModelFile)this.models().cross(name7, this.modLoc("block/" + ChippedBlockTypes.WARPED_FUNGUS + "/" + name7)));
        }
        for (RegistryObject<MushroomBlock> registryObject : ChippedBlockTypes.CRIMSON_FUNGUS.getBlocks()) {
            String name8 = registryObject.getId().func_110623_a();
            this.simpleBlock((Block)registryObject.get(), (ModelFile)this.models().cross(name8, this.modLoc("block/" + ChippedBlockTypes.CRIMSON_FUNGUS + "/" + name8)));
        }
        for (RegistryObject<MushroomBlock> registryObject : ChippedBlockTypes.WARPED_ROOTS.getBlocks()) {
            String name9 = registryObject.getId().func_110623_a();
            this.simpleBlock((Block)registryObject.get(), (ModelFile)this.models().cross(name9, this.modLoc("block/" + ChippedBlockTypes.WARPED_ROOTS + "/" + name9)));
        }
        for (RegistryObject<MushroomBlock> registryObject : ChippedBlockTypes.CRIMSON_ROOTS.getBlocks()) {
            String name10 = registryObject.getId().func_110623_a();
            this.simpleBlock((Block)registryObject.get(), (ModelFile)this.models().cross(name10, this.modLoc("block/" + ChippedBlockTypes.CRIMSON_ROOTS + "/" + name10)));
        }
        for (RegistryObject<MushroomBlock> registryObject : ChippedBlockTypes.NETHER_SPROUTS.getBlocks()) {
            String name11 = registryObject.getId().func_110623_a();
            this.simpleBlock((Block)registryObject.get(), (ModelFile)this.models().cross(name11, this.modLoc("block/" + ChippedBlockTypes.NETHER_SPROUTS + "/" + name11)));
        }
        for (RegistryObject<MushroomBlock> registryObject : ChippedBlockTypes.COBWEBS.getBlocks()) {
            String name12 = registryObject.getId().func_110623_a();
            this.simpleBlock((Block)registryObject.get(), (ModelFile)this.models().cross(name12, this.modLoc("block/" + ChippedBlockTypes.COBWEBS + "/" + name12)));
        }
        for (RegistryObject<MushroomBlock> registryObject : ChippedBlockTypes.LANTERNS) {
            if (!(registryObject.get() instanceof LanternBlock)) continue;
            this.getVariantBuilder((Block)registryObject.get()).partialState().with((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().getExistingFile(new ResourceLocation("chipped", "block/lanterns/" + registryObject.getId().func_110623_a()))).addModel();
            this.getVariantBuilder((Block)registryObject.get()).partialState().with((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().getExistingFile(new ResourceLocation("chipped", "block/lanterns/" + registryObject.getId().func_110623_a() + "_hanging"))).addModel();
        }
        for (RegistryObject<MushroomBlock> registryObject : ChippedBlockTypes.SOUL_LANTERNS) {
            if (!(registryObject.get() instanceof LanternBlock)) continue;
            String name13 = registryObject.getId().func_110623_a();
            this.getVariantBuilder((Block)registryObject.get()).partialState().with((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().getExistingFile(new ResourceLocation("chipped", "block/lanterns/" + name13))).addModel();
            this.getVariantBuilder((Block)registryObject.get()).partialState().with((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().getExistingFile(new ResourceLocation("chipped", "block/lanterns/" + name13 + "_hanging"))).addModel();
        }
        List<RegistryObject<RedstoneLampBlock>> redstoneLampBlocks = ChippedBlockTypes.REDSTONE_LAMPS.getBlocks();
        boolean bl2 = true;
        while (var4_54 <= 18) {
            Block lamp = (Block)redstoneLampBlocks.get((int)(var4_54 - true)).get();
            this.getVariantBuilder(lamp).partialState().with((Property)RedstoneLampBlock.field_196502_a, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().cubeAll("redstone_lamp_" + (int)var4_54, this.modLoc("block/redstone_lamp/redstone_lamp_off_" + (int)var4_54))).addModel();
            this.getVariantBuilder(lamp).partialState().with((Property)RedstoneLampBlock.field_196502_a, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().cubeAll("redstone_lamp_on_" + (int)var4_54, this.modLoc("block/redstone_lamp/redstone_lamp_on_" + (int)var4_54))).addModel();
            ++var4_54;
        }
        List<RegistryObject<TorchBlock>> list2 = ChippedBlockTypes.TORCHES.getBlocks();
        List<RegistryObject<WallTorchBlock>> wallTorches = ChippedBlocks.WALL_TORCHES;
        for (int i6 = 1; i6 <= 9; ++i6) {
            RegistryObject<TorchBlock> torchBlock = list2.get(i6 - 1);
            this.simpleBlock((Block)torchBlock.get(), (ModelFile)this.models().torch(torchBlock.getId().func_110623_a(), this.modLoc("block/torch/torch_" + i6)));
            Iterator wallTorchBlock = (Block)wallTorches.get(i6 - 1).get();
            for (Direction dir : RedstoneWallTorchBlock.field_196530_b.func_177700_c()) {
                int angle = Chipped.getTorchAngleFromDir(dir);
                this.getVariantBuilder((Block)wallTorchBlock).partialState().with((Property)RedstoneWallTorchBlock.field_196530_b, (Comparable)dir).modelForState().modelFile((ModelFile)this.models().torchWall("wall_torch_" + i6, this.modLoc("block/torch/torch_" + i6))).rotationY(angle).addModel();
            }
        }
        List<RegistryObject<CarvedPumpkinBlock>> vanillaCarved = ChippedBlocks.VANILLA_CARVED_PUMPKINS;
        for (int i7 = 0; i7 < ChippedBlocks.carvedPumpkinList.length * 2; ++i7) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                String carvedBlockName = vanillaCarved.get(i7).getId().func_110623_a();
                String carvedSubstring = carvedBlockName.substring(0, carvedBlockName.length() - (1 + i7 / 2 >= 10 ? 2 : 1));
                String blockPath = "block/pumpkin/" + carvedSubstring + ChippedBlocks.carvedPumpkinList[i7 / 2 % ChippedBlocks.carvedPumpkinList.length];
                this.getVariantBuilder((Block)vanillaCarved.get(i7).get()).partialState().with((Property)CarvedPumpkinBlock.field_196359_a, (Comparable)direction).modelForState().modelFile((ModelFile)this.models().orientable(carvedBlockName, this.mcLoc("block/pumpkin_side"), this.modLoc(blockPath), this.mcLoc("block/pumpkin_top"))).rotationY(Chipped.getAngleFromDir(direction)).addModel();
            }
        }
        List<RegistryObject<CarvedPumpkinBlock>> specialCarved = ChippedBlocks.SPECIAL_CARVED_PUMPKINS;
        List<RegistryObject<PumpkinBlock>> specialPumpkins = ChippedBlockTypes.PUMPKINS.getBlocks();
        for (i = 0; i < ChippedBlocks.specialPumpkinList.length * 2; i += 2) {
            this.registerSpecialPumpkins(specialCarved, specialPumpkins, i);
        }
        for (i = 1; i < ChippedBlocks.specialPumpkinList.length * 2; i += 2) {
            this.registerSpecialPumpkins(specialCarved, specialPumpkins, i);
        }
        this.registerRedstoneTorches();
        this.registerRedstoneTorchWall();
    }

    private <T extends Block> void createCubeFromList(ChippedBlockType<?> ... blockLists) {
        for (ChippedBlockType<?> blockList : blockLists) {
            this.createCubeFromList(blockList);
        }
    }

    private <T extends Block> void createCubeFromList(ChippedBlockType<?> blockList) {
        for (RegistryObject<?> block : blockList) {
            this.simpleBlock((Block)block.get(), (ModelFile)this.models().cubeAll(block.getId().func_110623_a(), this.modLoc("block/" + blockList + "/" + block.getId().func_110623_a())));
        }
    }

    private <T extends Block> void registerGlassPanes(ChippedBlockType<T> type, String originalType, String topName, int start, int end) {
        this.registerGlassPanes(type, type.getId(), originalType, null, topName, start, end);
    }

    private <T extends Block> void registerGlassPanes(ChippedBlockType<T> type, String originalType, String originalPath, String topName, int start, int end) {
        this.registerGlassPanes(type, type.getId(), originalType, originalPath, topName, start, end);
    }

    private <T extends Block> void registerGlassPanes(ChippedBlockType<T> type, String glassPaneName, String originalType, String originalPath, String topName, int start, int end) {
        List blocks = type.getBlocks().stream().filter(t -> t.getId().func_110623_a().startsWith(glassPaneName)).collect(Collectors.toList());
        for (int i = start; i <= end; ++i) {
            String block = glassPaneName + "_" + i;
            String originalBlock = originalType + "_" + i;
            if (originalPath == null) {
                originalPath = originalType;
            }
            this.getMultipartBuilder((Block)((RegistryObject)blocks.get(i - 1)).get()).part().modelFile((ModelFile)this.models().panePost(block + "_post", this.modLoc("block/" + originalPath + "/" + originalBlock), this.modLoc("block/glass_pane/" + topName))).addModel();
            ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)((RegistryObject)blocks.get(i - 1)).get()).part().modelFile((ModelFile)this.models().paneSide(block + "_side", this.modLoc("block/" + originalPath + "/" + originalBlock), this.modLoc("block/glass_pane/" + topName))).addModel()).condition((Property)FourWayBlock.field_196409_a, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)((RegistryObject)blocks.get(i - 1)).get()).part().modelFile((ModelFile)this.models().paneSide(block + "_side", this.modLoc("block/" + originalPath + "/" + originalBlock), this.modLoc("block/glass_pane/" + topName))).rotationY(90).addModel()).condition((Property)FourWayBlock.field_196411_b, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)((RegistryObject)blocks.get(i - 1)).get()).part().modelFile((ModelFile)this.models().paneSideAlt(block + "_side_alt", this.modLoc("block/" + originalPath + "/" + originalBlock), this.modLoc("block/glass_pane/" + topName))).addModel()).condition((Property)FourWayBlock.field_196413_c, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)((RegistryObject)blocks.get(i - 1)).get()).part().modelFile((ModelFile)this.models().paneSideAlt(block + "_side_alt", this.modLoc("block/" + originalPath + "/" + originalBlock), this.modLoc("block/" + originalPath + "/" + originalBlock))).rotationY(90).addModel()).condition((Property)FourWayBlock.field_196414_y, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)((RegistryObject)blocks.get(i - 1)).get()).part().modelFile((ModelFile)this.models().paneNoSide(block + "_noside", this.modLoc("block/" + originalPath + "/" + originalBlock))).addModel()).condition((Property)FourWayBlock.field_196409_a, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)((RegistryObject)blocks.get(i - 1)).get()).part().modelFile((ModelFile)this.models().paneNoSideAlt(block + "_noside_alt", this.modLoc("block/" + originalPath + "/" + originalBlock))).addModel()).condition((Property)FourWayBlock.field_196411_b, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)((RegistryObject)blocks.get(i - 1)).get()).part().modelFile((ModelFile)this.models().paneNoSideAlt(block + "_noside_alt", this.modLoc("block/" + originalPath + "/" + originalBlock))).rotationY(90).addModel()).condition((Property)FourWayBlock.field_196413_c, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)((RegistryObject)blocks.get(i - 1)).get()).part().modelFile((ModelFile)this.models().paneNoSide(block + "_noside", this.modLoc("block/" + originalPath + "/" + originalBlock))).rotationY(270).addModel()).condition((Property)FourWayBlock.field_196414_y, (Comparable[])new Boolean[]{false});
        }
    }

    private void registerRedstoneTorches() {
        List<RegistryObject<RedstoneTorchBlock>> torches = ChippedBlockTypes.REDSTONE_TORCHES.getBlocks();
        for (int i = 2; i <= torches.size() + 1; ++i) {
            ((VariantBlockStateBuilder)this.getVariantBuilder((Block)torches.get(i - 2).get()).partialState().with((Property)RedstoneTorchBlock.field_196528_a, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().torch("redstone_torch_" + i + "_off", this.modLoc("block/redstone_torch/redstone_torch_" + i + "_off"))).addModel()).partialState().with((Property)RedstoneTorchBlock.field_196528_a, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().torch("redstone_torch_" + i, this.modLoc("block/redstone_torch/redstone_torch_" + i))).addModel();
        }
    }

    private void registerRedstoneTorchWall() {
        List<RegistryObject<RedstoneWallTorchBlock>> torches = ChippedBlocks.REDSTONE_WALL_TORCHES;
        for (int i = 2; i <= torches.size() + 1; ++i) {
            for (Direction dir : RedstoneWallTorchBlock.field_196530_b.func_177700_c()) {
                int angle = Chipped.getTorchAngleFromDir(dir);
                ((VariantBlockStateBuilder)this.getVariantBuilder((Block)torches.get(i - 2).get()).partialState().with((Property)RedstoneWallTorchBlock.field_196530_b, (Comparable)dir).with((Property)RedstoneTorchBlock.field_196528_a, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().torchWall("redstone_wall_torch_" + i, this.modLoc("block/redstone_torch/redstone_torch_" + i))).rotationY(angle).addModel()).partialState().with((Property)RedstoneWallTorchBlock.field_196530_b, (Comparable)dir).with((Property)RedstoneWallTorchBlock.field_196531_c, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().torchWall("redstone_wall_torch_" + i + "_off", this.modLoc("block/redstone_torch/redstone_torch_" + i + "_off"))).rotationY(angle).addModel();
            }
        }
    }

    private void registerSpecialPumpkins(List<RegistryObject<CarvedPumpkinBlock>> specialCarved, List<RegistryObject<PumpkinBlock>> specialPumpkins, int index) {
        String carvedBlockName = specialCarved.get(index).getId().func_110623_a();
        String pumpkinName = specialPumpkins.get(index / 2).getId().func_110623_a();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.getVariantBuilder((Block)specialCarved.get(index).get()).partialState().with((Property)CarvedPumpkinBlock.field_196359_a, (Comparable)direction).modelForState().modelFile((ModelFile)this.models().orientable(carvedBlockName, this.modLoc("block/pumpkin/" + pumpkinName + "_side"), this.modLoc("block/pumpkin/" + carvedBlockName), this.modLoc("block/pumpkin/" + pumpkinName + "_top"))).rotationY(Chipped.getAngleFromDir(direction)).addModel();
        }
    }
}

