/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped.container;

import com.grimbo.chipped.container.ChippedContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;

public class ChippedScreen
extends ContainerScreen<ChippedContainer> {
    private static final ResourceLocation BG_LOCATION = new ResourceLocation("textures/gui/container/stonecutter.png");
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public ChippedScreen(ChippedContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        container.registerUpdateListener(this::containerChanged);
        --this.field_238743_q_;
    }

    public void func_230430_a_(@NotNull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
    }

    protected void func_230450_a_(@NotNull MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BG_LOCATION);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrix, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int k = (int)(41.0f * this.scrollOffs);
        this.func_238474_b_(matrix, i + 119, j + 15 + k, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int l = this.field_147003_i + 52;
        int i1 = this.field_147009_r + 14;
        int j1 = this.startIndex + 12;
        this.renderButtons(matrix, mouseX, mouseY, l, i1, j1);
        this.renderRecipes(l, i1, j1);
    }

    protected void func_230459_a_(@NotNull MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230459_a_(matrix, mouseX, mouseY);
        if (this.displayRecipes) {
            int i = this.field_147003_i + 52;
            int j = this.field_147009_r + 14;
            int k = this.startIndex + 12;
            List<ItemStack> list = ((ChippedContainer)this.field_147002_h).getResults();
            for (int l = this.startIndex; l < k && l < list.size(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (mouseX < j1 || mouseX >= j1 + 16 || mouseY < k1 || mouseY >= k1 + 18) continue;
                this.func_230457_a_(matrix, list.get(l), mouseX, mouseY);
            }
        }
    }

    private void renderButtons(MatrixStack matrix, int mouseX, int mouseY, int p_238853_4_, int p_238853_5_, int p_238853_6_) {
        for (int i = this.startIndex; i < p_238853_6_ && i < ((ChippedContainer)this.field_147002_h).getResults().size(); ++i) {
            int j = i - this.startIndex;
            int k = p_238853_4_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_238853_5_ + l * 18 + 2;
            int j1 = this.field_147000_g;
            if (i == ((ChippedContainer)this.field_147002_h).getSelectedIndex()) {
                j1 += 18;
            } else if (mouseX >= k && mouseY >= i1 && mouseX < k + 16 && mouseY < i1 + 18) {
                j1 += 36;
            }
            this.func_238474_b_(matrix, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void renderRecipes(int p_214142_1_, int p_214142_2_, int p_214142_3_) {
        List<ItemStack> list = ((ChippedContainer)this.field_147002_h).getResults();
        for (int i = this.startIndex; i < p_214142_3_ && i < list.size(); ++i) {
            int j = i - this.startIndex;
            int k = p_214142_1_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_214142_2_ + l * 18 + 2;
            this.field_230706_i_.func_175599_af().func_180450_b(list.get(i), k, i1);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.field_147003_i + 52;
            int j = this.field_147009_r + 14;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int i1 = l - this.startIndex;
                double d0 = mouseX - (double)(i + i1 % 4 * 16);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((ChippedContainer)this.field_147002_h).func_75140_a((PlayerEntity)this.field_230706_i_.field_71439_g, l)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219720_mm, (float)1.0f));
                this.field_230706_i_.field_71442_b.func_78756_a(((ChippedContainer)this.field_147002_h).field_75152_c, l);
                return true;
            }
            i = this.field_147003_i + 119;
            j = this.field_147009_r + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.scrolling = true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.field_147009_r + 14;
            int j = i + 54;
            this.scrollOffs = ((float)p_231045_3_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = MathHelper.func_76131_a((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.func_231045_a_(p_231045_1_, p_231045_3_, p_231045_5_, p_231045_6_, p_231045_8_);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scrollAmount) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - scrollAmount / (double)i);
            this.scrollOffs = MathHelper.func_76131_a((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((ChippedContainer)this.field_147002_h).getResults().size() > 12;
    }

    protected int getOffscreenRows() {
        return (((ChippedContainer)this.field_147002_h).getResults().size() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((ChippedContainer)this.field_147002_h).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }
}

