/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped.container;

import com.google.common.base.Suppliers;
import com.grimbo.chipped.recipe.ChippedRecipe;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ChippedContainer
extends Container {
    private final IWorldPosCallable access;
    private final IntReferenceHolder selectedRecipeIndex = IntReferenceHolder.func_221492_a();
    private final World level;
    private ChippedRecipe recipe;
    private Supplier<List<ItemStack>> results;
    private ItemStack input = ItemStack.field_190927_a;
    private long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    private Runnable slotUpdateListener = () -> {};
    public final IInventory container = new Inventory(1){

        public void func_70296_d() {
            super.func_70296_d();
            ChippedContainer.this.func_75130_a((IInventory)this);
            ChippedContainer.this.slotUpdateListener.run();
        }
    };
    private final CraftResultInventory resultContainer = new CraftResultInventory();
    private final ContainerType<ChippedContainer> containerType;
    private IRecipeType<ChippedRecipe> recipeType;
    private Block blockWorkbench;

    public ChippedContainer(int id, PlayerInventory inventory, IWorldPosCallable posCallable, ContainerType<ChippedContainer> container, IRecipeType<ChippedRecipe> recipe, Block block) {
        this(container, id, inventory, posCallable);
        this.recipeType = recipe;
        this.blockWorkbench = block;
    }

    public ChippedContainer(ContainerType<ChippedContainer> container, int id, PlayerInventory inventory, final IWorldPosCallable posCallable) {
        super(container, id);
        this.containerType = container;
        this.access = posCallable;
        this.level = inventory.field_70458_d.field_70170_p;
        this.inputSlot = this.func_75146_a(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.func_75146_a(new Slot((IInventory)this.resultContainer, 1, 143, 33){

            public boolean func_75214_a(@NotNull ItemStack stack) {
                return false;
            }

            @NotNull
            public ItemStack func_190901_a(@NotNull PlayerEntity player, @NotNull ItemStack stack) {
                stack.func_77980_a(player.field_70170_p, player, stack.func_190916_E());
                ChippedContainer.this.resultContainer.func_201560_d(player);
                ItemStack itemstack = ChippedContainer.this.inputSlot.func_75209_a(1);
                if (!itemstack.func_190926_b()) {
                    ChippedContainer.this.setupResultSlot();
                }
                posCallable.func_221486_a((p_216954_1_, p_216954_2_) -> {
                    long l = p_216954_1_.func_82737_E();
                    if (ChippedContainer.this.lastSoundTime != l) {
                        p_216954_1_.func_184133_a(null, p_216954_2_, SoundEvents.field_219719_ml, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        ChippedContainer.this.lastSoundTime = l;
                    }
                });
                return super.func_190901_a(player, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)inventory, k, 8 + k * 18, 142));
        }
        this.func_216958_a(this.selectedRecipeIndex);
    }

    public int getSelectedIndex() {
        return this.selectedRecipeIndex.func_221495_b();
    }

    public List<ItemStack> getResults() {
        return this.results == null ? Collections.emptyList() : this.results.get();
    }

    public boolean hasInputItem() {
        return this.inputSlot.func_75216_d() && this.results != null;
    }

    public boolean func_75145_c(@NotNull PlayerEntity player) {
        return ChippedContainer.func_216963_a((IWorldPosCallable)this.access, (PlayerEntity)player, (Block)this.blockWorkbench);
    }

    public boolean func_75140_a(@NotNull PlayerEntity player, int index) {
        if (this.isValidRecipeIndex(index)) {
            this.selectedRecipeIndex.func_221494_a(index);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int index) {
        return index >= 0 && index < this.getResults().size();
    }

    public void func_75130_a(@NotNull IInventory inventory) {
        ItemStack itemstack = this.inputSlot.func_75211_c();
        if (itemstack.func_77973_b() != this.input.func_77973_b()) {
            this.input = itemstack.func_77946_l();
            this.setupRecipeList(inventory, itemstack);
        }
    }

    private void setupRecipeList(IInventory inventory, ItemStack stack) {
        this.results = null;
        this.selectedRecipeIndex.func_221494_a(-1);
        this.resultSlot.func_75215_d(ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            this.recipe = this.level.func_199532_z().func_215371_a(this.recipeType, inventory, this.level).orElse(null);
            if (this.recipe != null) {
                this.results = Suppliers.memoize(() -> this.recipe.getResults(inventory).collect(Collectors.toList()));
            }
        }
    }

    private void setupResultSlot() {
        if (this.recipe != null && this.results != null && !this.results.get().isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.func_221495_b())) {
            this.resultContainer.func_193056_a((IRecipe)this.recipe);
            this.resultSlot.func_75215_d(this.results.get().get(this.selectedRecipeIndex.func_221495_b()).func_77946_l());
        } else {
            this.resultSlot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    @NotNull
    public ContainerType<?> func_216957_a() {
        return this.containerType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerUpdateListener(Runnable p_217071_1_) {
        this.slotUpdateListener = p_217071_1_;
    }

    public boolean func_94530_a(@NotNull ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.resultContainer && super.func_94530_a(stack, slot);
    }

    @NotNull
    public ItemStack func_82846_b(@NotNull PlayerEntity player, int p_82846_2_) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(p_82846_2_);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            Item item = itemstack1.func_77973_b();
            itemstack = itemstack1.func_77946_l();
            if (p_82846_2_ == 1) {
                item.func_77622_d(itemstack1, player.field_70170_p, player);
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (p_82846_2_ == 0 ? !this.func_75135_a(itemstack1, 2, 38, false) : (this.level.func_199532_z().func_215371_a(this.recipeType, (IInventory)new Inventory(new ItemStack[]{itemstack1}), this.level).isPresent() ? !this.func_75135_a(itemstack1, 0, 1, false) : (p_82846_2_ < 29 ? !this.func_75135_a(itemstack1, 29, 38, false) : p_82846_2_ < 38 && !this.func_75135_a(itemstack1, 2, 29, false)))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
            this.func_75142_b();
        }
        return itemstack;
    }

    public void func_75134_a(@NotNull PlayerEntity player) {
        super.func_75134_a(player);
        this.resultContainer.func_70304_b(1);
        this.access.func_221486_a((p_217079_2_, p_217079_3_) -> this.func_193327_a(player, player.field_70170_p, this.container));
    }
}

