/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.checklist.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class ChecklistWorldSavedData
extends WorldSavedData {
    private static final String DATA_NAME = "checklist_SAFE";
    private final Map<UUID, List<String>> tasks = new HashMap<UUID, List<String>>();
    private final List<UUID> firstJoin = new ArrayList<UUID>();

    public ChecklistWorldSavedData() {
        super(DATA_NAME);
    }

    public ChecklistWorldSavedData(String s) {
        super(s);
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT tagList = (ListNBT)nbt.func_74781_a("checklist");
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tag = tagList.func_150305_b(i);
            UUID uuid = UUID.fromString(tag.func_74779_i("uuid"));
            if (tag.func_74764_b("firstJoin") && tag.func_74767_n("firstJoin")) {
                this.firstJoin.add(uuid);
            }
            if (!tag.func_74764_b("tasks")) continue;
            ListNBT taskList = (ListNBT)tag.func_74781_a("tasks");
            for (int j = 0; j < taskList.size(); ++j) {
                String task = taskList.func_150307_f(j);
                this.tasks.compute(uuid, (uuid1, strings) -> {
                    if (strings == null) {
                        strings = new ArrayList<String>();
                    }
                    strings.add(task);
                    return strings;
                });
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT tagList = new ListNBT();
        for (UUID uuid : Stream.concat(this.tasks.keySet().stream(), this.firstJoin.stream()).collect(Collectors.toSet())) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("uuid", uuid.toString());
            if (this.tasks.containsKey(uuid)) {
                ListNBT nbtTasks = new ListNBT();
                for (String task : this.tasks.get(uuid)) {
                    nbtTasks.add((Object)StringNBT.func_229705_a_((String)task));
                }
                tag.func_218657_a("tasks", (INBT)nbtTasks);
            }
            if (this.firstJoin.contains(uuid)) {
                tag.func_74757_a("firstJoin", true);
            }
            tagList.add((Object)tag);
        }
        compound.func_218657_a("checklist", (INBT)tagList);
        return compound;
    }

    public static ChecklistWorldSavedData get(World worldIn) {
        if (!(worldIn instanceof ServerWorld)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        DimensionSavedDataManager storage = ((ServerWorld)worldIn).func_73046_m().func_241755_D_().func_217481_x();
        return (ChecklistWorldSavedData)storage.func_215752_a(ChecklistWorldSavedData::new, DATA_NAME);
    }

    public Map<UUID, List<String>> getTasks() {
        return this.tasks;
    }

    public boolean hasPlayerFirstJoin(UUID uuid) {
        return this.firstJoin.contains(uuid);
    }

    public void addPlayerFirstJoin(UUID uuid) {
        this.firstJoin.add(uuid);
    }
}

